/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.parser.prefixTree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.CollectionSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.youtrack.parser.lexer.CharIterable;
import jetbrains.youtrack.parser.lexer.CharIterator;
import jetbrains.youtrack.parser.lexer.CharSequenceIterable;
import jetbrains.youtrack.parser.prefixTree.IPredicate;
import jetbrains.youtrack.parser.prefixTree.Node;
import jetbrains.youtrack.parser.prefixTree.PrefixCollection;
import jetbrains.youtrack.parser.prefixTree.PrefixIterator;
import jetbrains.youtrack.parser.prefixTree.TraversablePrefixIterable;

public class PrefixTree<T>
implements PrefixCollection<T, T>,
TraversablePrefixIterable<T> {
    private static int[] loweredChars = new int[256];
    private final Node<T> root;
    private final boolean caseInsensitive;
    private List<Integer> deletedIndices;
    private final NavigableMap<Long, Node<T>> parentToChildren;

    public PrefixTree() {
        this(true);
    }

    public PrefixTree(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        this.parentToChildren = new TreeMap<Long, Node<T>>();
        this.root = this.createNode();
    }

    @Override
    public int getNodesCount() {
        return this.parentToChildren.size();
    }

    public Node addValue(CharSequence key, T value) {
        return this.addValue((CharIterable)new CharSequenceIterable(key), value);
    }

    @Override
    public Node addValue(CharIterable key, T value) {
        Node<T> node = this.getDescendantNode(null, key, true);
        node.addValue(value);
        return node;
    }

    public Iterable<T> removeValues(CharSequence key, IPredicate<T> predicate) {
        return this.removeValues((CharIterable)new CharSequenceIterable(key), predicate);
    }

    @Override
    public Iterable<T> removeValues(CharIterable key, IPredicate<T> predicate) {
        ArrayList<Node> path = new ArrayList<Node>();
        Node node = this.root;
        CharIterator i = key.iterator();
        while (i.hasNext()) {
            path.add(node);
            Node<T> childNode = this.getChildNode(node, i.next(), false);
            if (childNode == null) {
                return null;
            }
            node = childNode;
        }
        Iterable<T> removedValues = node.removeValues(predicate);
        int pathElementIndex = path.size() - 1;
        CharIterator i2 = key.reverseIterator();
        while (i2.hasNext() && !node.hasValues() && !this.hasChildNodes(node)) {
            Node parentNode = (Node)path.get(pathElementIndex--);
            this.deleteNode(parentNode, i2.next());
            node = parentNode;
        }
        return removedValues;
    }

    public Node replaceValue(CharSequence oldKey, IPredicate<T> predicate, CharSequence newKey, T newValue) {
        this.removeValues(oldKey, predicate);
        return this.addValue(newKey, newValue);
    }

    @Override
    public PrefixIterator<T> prefixIterator() {
        return new TreeIterator(this);
    }

    @Override
    public void traverse(_FunctionTypes._void_P2_E0<? super CharSequence, ? super Iterable<T>> f) {
        this.traverse(this.root, new StringBuilder(), f);
    }

    private void traverse(Node<T> node, StringBuilder builder, _FunctionTypes._void_P2_E0<? super CharSequence, ? super Iterable<T>> f) {
        f.invoke((Object)builder, node.getValues());
        int length = builder.length();
        for (Map.Entry child : SetSequence.fromSet(this.getChildNodesSubmap(node).entrySet())) {
            char c = (char)((Long)child.getKey() & 0xFFFFL);
            builder.append(c);
            this.traverse((Node)child.getValue(), builder, f);
            builder.setLength(length);
        }
    }

    private Node<T> getDescendantNode(Node<T> node, CharIterable subkey, boolean create) {
        if (node == null) {
            node = this.root;
        }
        CharIterator i = subkey.iterator();
        while (i.hasNext() && (node = this.getChildNode(node, i.next(), create)) != null) {
        }
        return node;
    }

    protected Iterable<T> getDescendantValues(Node<T> node) {
        if (node == null) {
            node = this.root;
        }
        return new MyIterable(node);
    }

    private Node<T> getChildNode(Node<T> node, char c, boolean create) {
        long nodeNumber = node.getNodeNumber();
        long childKey = nodeNumber << 16 | (long)this.getChar(c);
        Node<T> childNode = (Node<T>)this.parentToChildren.get(childKey);
        if (create && childNode == null) {
            childNode = this.createNode();
            this.parentToChildren.put(childKey, childNode);
        }
        return childNode;
    }

    private boolean hasChildNodes(Node<T> node) {
        return !this.getChildNodesSubmap(node).isEmpty();
    }

    private Node<T> createNode() {
        int nodeNumber = this.deletedIndices != null && !this.deletedIndices.isEmpty() ? this.deletedIndices.remove(this.deletedIndices.size() - 1) : this.parentToChildren.size() + (this.root != null ? 1 : 0);
        return new Node(nodeNumber);
    }

    private NavigableMap<Long, Node<T>> getChildNodesSubmap(Node<T> node) {
        long nodeNumber = node.getNodeNumber();
        long lowBound = nodeNumber << 16;
        long highBound = lowBound | 0xFFFFL;
        return this.parentToChildren.subMap(lowBound, true, highBound, true);
    }

    private void deleteNode(Node<T> parentNode, char c) {
        long nodeNumber = parentNode.getNodeNumber();
        long childKey = nodeNumber << 16 | (long)this.getChar(c);
        Node childNode = (Node)this.parentToChildren.remove(childKey);
        if (this.deletedIndices == null) {
            this.deletedIndices = new ArrayList<Integer>(1);
        }
        this.deletedIndices.add(childNode.getNodeNumber());
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Node<T> subtree) {
        if (subtree == null) {
            subtree = this.root;
        }
        StringBuilder builder = new StringBuilder();
        this.append(subtree, builder, 0);
        return builder.toString();
    }

    private void append(Node<T> subtree, StringBuilder builder, int offset) {
        builder.append('{').append(subtree.getNodeNumber()).append('}');
        subtree.appendToString(builder);
        for (Map.Entry pair : SetSequence.fromSet(this.getChildNodesSubmap(subtree).entrySet())) {
            builder.append('\n');
            for (int i = 0; i < offset + 2; ++i) {
                builder.append(' ');
            }
            builder.append((char)((Long)pair.getKey() & 0xFFFFL)).append(": ");
            this.append((Node)pair.getValue(), builder, offset + 2);
        }
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    private char getChar(char c) {
        return this.caseInsensitive ? (char)PrefixTree.toLowerCase(c) : c;
    }

    public static int toLowerCase(int c) {
        return c >= 0 && c < loweredChars.length ? loweredChars[c] : Character.toLowerCase(c);
    }

    static {
        for (int i = 0; i < loweredChars.length; ++i) {
            PrefixTree.loweredChars[i] = Character.toLowerCase(i);
        }
    }

    public static class MyIteratorStates {
        private static final int UNKNOWN_NEXT = 0;
        private static final int HAS_NEXT = 1;
        private static final int NO_NEXT = 2;
    }

    public class MyIterator
    implements Iterator<T> {
        private List<Node<T>> stack = ListSequence.fromList(new ArrayList());
        private Iterator<T> currentValues;
        private T nextElement;
        private int state = 0;

        public MyIterator(Node<T> subTreeRoot) {
            ListSequence.fromList(this.stack).addElement(subTreeRoot);
        }

        @Override
        public boolean hasNext() {
            switch (this.state) {
                case 0: {
                    return this.advance();
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                this.state = 0;
                return this.nextElement;
            }
            throw new NoSuchElementException();
        }

        private boolean advance() {
            if (this.currentValues != null && this.currentValues.hasNext()) {
                this.nextElement = this.currentValues.next();
                this.state = 1;
                return true;
            }
            while (ListSequence.fromList(this.stack).isNotEmpty()) {
                Node currentNode = (Node)ListSequence.fromList(this.stack).removeLastElement();
                Collection reverseChildren = PrefixTree.this.getChildNodesSubmap(currentNode).descendingMap().values();
                ListSequence.fromList(this.stack).addSequence((ISequence)CollectionSequence.fromCollection(reverseChildren));
                if (!currentNode.hasValues()) continue;
                this.currentValues = Sequence.fromIterable(currentNode.getValues()).iterator();
                this.nextElement = this.currentValues.next();
                this.state = 1;
                return true;
            }
            this.state = 2;
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class MyIterable
    implements Iterable<T> {
        private Node<T> subTreeRoot;

        public MyIterable(Node<T> subTreeRoot) {
            this.subTreeRoot = subTreeRoot;
        }

        @Override
        public Iterator<T> iterator() {
            return new MyIterator(this.subTreeRoot);
        }
    }

    public static class TreeIterator<S>
    implements PrefixIterator<S> {
        protected PrefixTree<S> tree;
        protected Node<S> node;

        protected TreeIterator(PrefixTree<S> tree) {
            this.tree = tree;
            this.node = ((PrefixTree)tree).root;
        }

        @Override
        public boolean move(CharIterable step) {
            if (this.node == null) {
                return false;
            }
            this.node = ((PrefixTree)this.tree).getDescendantNode(this.node, step, false);
            return this.node != null;
        }

        protected Iterable<S> preselectValues(Iterable<S> values) {
            return values;
        }

        @Override
        public Iterable<S> getValues(final IPredicate<S> predicate) {
            ISequence values = null;
            if (this.node != null) {
                values = this.preselectValues(this.node.getValues());
                if (predicate != null) {
                    values = Sequence.fromIterable(values).where((_FunctionTypes._return_P1_E0)new IWhereFilter<S>(){

                        public boolean accept(S it) {
                            return predicate.matches(it);
                        }
                    });
                }
            }
            return values;
        }

        @Override
        public Iterable<S> getDescendantValues(final IPredicate<S> predicate) {
            ISequence values = null;
            if (this.node != null) {
                values = this.preselectValues(this.tree.getDescendantValues(this.node));
                if (predicate != null) {
                    values = Sequence.fromIterable(values).where((_FunctionTypes._return_P1_E0)new IWhereFilter<S>(){

                        public boolean accept(S it) {
                            return predicate.matches(it);
                        }
                    });
                }
            }
            return values;
        }
    }
}

