/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.parser.prefixTree;

import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.youtrack.parser.lexer.CharIterable;
import jetbrains.youtrack.parser.lexer.CharIterator;
import jetbrains.youtrack.parser.lexer.CharSequenceIterable;
import jetbrains.youtrack.parser.lexer.SingletonCharIterable;
import jetbrains.youtrack.parser.prefixTree.IPredicate;
import jetbrains.youtrack.parser.prefixTree.PrefixIterable;
import jetbrains.youtrack.parser.prefixTree.PrefixIterator;
import jetbrains.youtrack.parser.prefixTree.StringUtils;
import jetbrains.youtrack.parser.prefixTree.TraversablePrefixIterable;

public class WildcardPrefixIterable<T>
implements PrefixIterable<T>,
TraversablePrefixIterable<T> {
    public static final char WILD_CARD = '*';
    public static final CharIterable WILD_CARD_ITERABLE = new SingletonCharIterable('*');
    private PrefixIterable<T> iterable;

    public WildcardPrefixIterable(PrefixIterable<T> iterable) {
        this.iterable = iterable;
    }

    @Override
    public int getNodesCount() {
        return this.iterable.getNodesCount();
    }

    @Override
    public PrefixIterator<T> prefixIterator() {
        return new WildcardIterator();
    }

    @Override
    public void traverse(_FunctionTypes._void_P2_E0<? super CharSequence, ? super Iterable<T>> f) {
        if (this.iterable instanceof TraversablePrefixIterable) {
            TraversablePrefixIterable traversablePrefixIterable = (TraversablePrefixIterable)((Object)this.iterable);
            traversablePrefixIterable.traverse(f);
        }
    }

    public class WildcardIterator
    implements PrefixIterator<T> {
        private PrefixIterator<T> iterator;
        private boolean wildcarded = false;

        private WildcardIterator() {
            this.iterator = WildcardPrefixIterable.this.iterable.prefixIterator();
        }

        @Override
        public boolean move(CharIterable step) {
            CharIterator i;
            if (this.wildcarded) {
                this.iterator.move(WILD_CARD_ITERABLE);
            }
            if ((i = step.reverseIterator()).hasNext() && i.next() == '*') {
                this.wildcarded = true;
                String s = step.toString();
                step = new CharSequenceIterable(StringUtils.substring(s, 0, s.length() - 1));
            }
            return this.iterator.move(step);
        }

        @Override
        public Iterable<T> getValues(IPredicate<T> predicate) {
            return this.wildcarded ? this.iterator.getDescendantValues(predicate) : this.iterator.getValues(predicate);
        }

        @Override
        public Iterable<T> getDescendantValues(IPredicate<T> predicate) {
            return this.iterator.getDescendantValues(predicate);
        }
    }
}

