/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.reports.impl.gantt;

import jetbrains.youtrack.reports.ReportCalculationException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0013\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0006J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001c"}, d2={"Ljetbrains/youtrack/reports/impl/gantt/TimestampCalculator;", "", "daysAWeek", "", "workDaysMask", "reportStartDate", "", "ownerTimeZone", "Lorg/joda/time/DateTimeZone;", "(IIJLorg/joda/time/DateTimeZone;)V", "getDaysAWeek", "()I", "getOwnerTimeZone", "()Lorg/joda/time/DateTimeZone;", "getReportStartDate", "()J", "getWorkDaysMask", "assertTimeTrackingSettingsInited", "", "calculate", "daysFromStart", "", "isStartPoint", "", "time", "isWorkDay", "dw", "Companion", "youtrack-reports"})
public final class TimestampCalculator {
    private final int daysAWeek;
    private final int workDaysMask;
    private final long reportStartDate;
    @NotNull
    private final DateTimeZone ownerTimeZone;
    private static final long MILLIS_IN_DAY = 86400000L;
    public static final Companion Companion = new Companion(null);

    public final float calculate(long time) {
        this.assertTimeTrackingSettingsInited();
        DateTime startDate = new DateTime(this.reportStartDate, this.ownerTimeZone);
        DateTime timeValue = new DateTime(time, DateTimeZone.UTC).withTimeAtStartOfDay();
        Days days = Days.daysBetween((ReadableInstant)((ReadableInstant)startDate), (ReadableInstant)((ReadableInstant)timeValue));
        Intrinsics.checkExpressionValueIsNotNull((Object)days, (String)"Days.daysBetween(startDate, timeValue)");
        int daysBetween = days.getDays();
        if (daysBetween <= 0) {
            return 0.0f;
        }
        int weeksBetween = daysBetween / 7;
        int result2 = weeksBetween * this.daysAWeek;
        DateTime current = startDate.plusWeeks(weeksBetween);
        while (current.compareTo((ReadableInstant)timeValue) < 0) {
            DateTime dateTime = current;
            Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"current");
            if (this.isWorkDay(dateTime.getDayOfWeek(), this.workDaysMask)) {
                ++result2;
            }
            current = current.plusDays(1);
        }
        return result2;
    }

    public final long calculate(float daysFromStart, boolean isStartPoint) {
        this.assertTimeTrackingSettingsInited();
        DateTimeZone ownerTimeZone = this.ownerTimeZone;
        long reportStartDate = this.reportStartDate;
        int weeks = (int)Math.floor(daysFromStart / (float)this.daysAWeek);
        long reminder = (long)Math.floor((daysFromStart - (float)(weeks * this.daysAWeek)) * (float)MILLIS_IN_DAY);
        long t = reportStartDate + (long)(weeks * 7) * MILLIS_IN_DAY;
        DateTime d0 = new DateTime(t, ownerTimeZone);
        int t01Day = d0.getDayOfWeek() % 7;
        DateTime dateTime = d0.withTime(0, 0, 0, 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"d0.withTime(0, 0, 0, 0)");
        long t0 = dateTime.getMillis();
        DateTime dateTime2 = d0.withTime(23, 59, 59, 999);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime2, (String)"d0.withTime(23, 59, 59, 999)");
        long t1 = dateTime2.getMillis() + 1L;
        if (daysFromStart == 0.0f) {
            while (!this.isWorkDay(t01Day, this.workDaysMask)) {
                t0 += MILLIS_IN_DAY;
                t01Day = (t01Day + 1) % 7;
            }
            return t0;
        }
        if (reminder == 0L) {
            if (isStartPoint) {
                if (this.isWorkDay(t01Day, this.workDaysMask)) {
                    return t;
                }
                while (!this.isWorkDay(t01Day, this.workDaysMask)) {
                    t0 += MILLIS_IN_DAY;
                    t01Day = (t01Day + 1) % 7;
                }
                return t0;
            }
            if (this.isWorkDay(t01Day, this.workDaysMask)) {
                if (!this.isWorkDay(new DateTime(t - 1L, ownerTimeZone).getDayOfWeek() % 7, this.workDaysMask)) {
                    t1 -= MILLIS_IN_DAY;
                    t01Day = (t01Day + 6) % 7;
                } else {
                    return t;
                }
            }
            while (!this.isWorkDay(t01Day, this.workDaysMask)) {
                t1 -= MILLIS_IN_DAY;
                t01Day = (t01Day + 6) % 7;
            }
            return t1;
        }
        reminder += t - t0;
        long result2 = t0;
        boolean isEndInTheMiddleOfDay = false;
        while (reminder > 0L) {
            if (this.isWorkDay(t01Day, this.workDaysMask)) {
                long reminderDec = Math.min(reminder, MILLIS_IN_DAY);
                if (reminder < MILLIS_IN_DAY) {
                    isEndInTheMiddleOfDay = true;
                }
                reminder -= reminderDec;
                result2 = t0 + reminderDec;
            }
            t0 += MILLIS_IN_DAY;
            t01Day = (t01Day + 1) % 7;
        }
        if (isEndInTheMiddleOfDay) {
            t01Day = (t01Day + 6) % 7;
        }
        if (isStartPoint) {
            while (!this.isWorkDay(t01Day, this.workDaysMask)) {
                result2 += MILLIS_IN_DAY;
                t01Day = (t01Day + 1) % 7;
            }
        }
        return result2;
    }

    public static /* synthetic */ long calculate$default(TimestampCalculator timestampCalculator, float f, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return timestampCalculator.calculate(f, bl);
    }

    private final void assertTimeTrackingSettingsInited() {
        if (this.daysAWeek == 0 || this.workDaysMask == 0) {
            throw (Throwable)new ReportCalculationException("The report cannot be calculated. The work days are not defined in the time tracking settings.");
        }
    }

    private final boolean isWorkDay(int dw, int workDaysMask) {
        return (1 << dw & workDaysMask) != 0;
    }

    public final int getDaysAWeek() {
        return this.daysAWeek;
    }

    public final int getWorkDaysMask() {
        return this.workDaysMask;
    }

    public final long getReportStartDate() {
        return this.reportStartDate;
    }

    @NotNull
    public final DateTimeZone getOwnerTimeZone() {
        return this.ownerTimeZone;
    }

    public TimestampCalculator(int daysAWeek, int workDaysMask, long reportStartDate, @NotNull DateTimeZone ownerTimeZone) {
        Intrinsics.checkParameterIsNotNull((Object)ownerTimeZone, (String)"ownerTimeZone");
        this.daysAWeek = daysAWeek;
        this.workDaysMask = workDaysMask;
        this.reportStartDate = reportStartDate;
        this.ownerTimeZone = ownerTimeZone;
    }

    static {
        MILLIS_IN_DAY = 86400000L;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/youtrack/reports/impl/gantt/TimestampCalculator$Companion;", "", "()V", "MILLIS_IN_DAY", "", "youtrack-reports"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

