/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.reports.impl.history.rate;

import java.util.List;
import jetbrains.charisma.smartui.parser.date.DatePeriod;
import jetbrains.youtrack.reports.ReportCalculationMonitor;
import jetbrains.youtrack.reports.ReportDataCalculator;
import jetbrains.youtrack.reports.impl.PeriodWithoutFuture;
import jetbrains.youtrack.reports.impl.XdReportEntityType;
import jetbrains.youtrack.reports.impl.history.rate.FixRateDataBuilder;
import jetbrains.youtrack.reports.impl.history.rate.RateDataBuilder;
import jetbrains.youtrack.reports.impl.history.rate.RateReportDataJson;
import jetbrains.youtrack.reports.impl.history.rate.ResolveRateDataBuilder;
import jetbrains.youtrack.reports.impl.history.rate.VerifyRateDataBuilder;
import jetbrains.youtrack.reports.impl.history.rate.XdFixRateReport;
import jetbrains.youtrack.reports.impl.history.rate.XdRateReport;
import jetbrains.youtrack.reports.impl.history.rate.XdResolveRateReport;
import jetbrains.youtrack.reports.impl.history.rate.XdVerifyRateReport;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service(value="rateReportDataCalculator")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016R$\u0010\u0005\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/reports/impl/history/rate/RateReportDataCalculator;", "Ljetbrains/youtrack/reports/ReportDataCalculator;", "Ljetbrains/youtrack/reports/impl/history/rate/RateReportDataJson;", "Ljetbrains/youtrack/reports/impl/history/rate/XdRateReport;", "()V", "suitableReportTypes", "", "Ljetbrains/youtrack/reports/impl/XdReportEntityType;", "getSuitableReportTypes", "()Ljava/util/List;", "calculate", "report", "monitor", "Ljetbrains/youtrack/reports/ReportCalculationMonitor;", "youtrack-reports"})
public final class RateReportDataCalculator
implements ReportDataCalculator<RateReportDataJson, XdRateReport> {
    @NotNull
    private final List<XdReportEntityType<RateReportDataJson, ?>> suitableReportTypes = CollectionsKt.listOf((Object[])new XdReportEntityType[]{XdFixRateReport.Companion, XdResolveRateReport.Companion, XdVerifyRateReport.Companion});

    @Override
    @NotNull
    public List<XdReportEntityType<RateReportDataJson, ?>> getSuitableReportTypes() {
        return this.suitableReportTypes;
    }

    @Override
    @NotNull
    public RateReportDataJson calculate(@NotNull XdRateReport report2, @NotNull ReportCalculationMonitor monitor) {
        RateDataBuilder rateDataBuilder;
        Intrinsics.checkParameterIsNotNull((Object)report2, (String)"report");
        Intrinsics.checkParameterIsNotNull((Object)monitor, (String)"monitor");
        long now = System.currentTimeMillis();
        PeriodWithoutFuture period = new PeriodWithoutFuture(report2.getRange(), now);
        String string = report2.getEntity().getType();
        if (Intrinsics.areEqual((Object)string, (Object)XdFixRateReport.Companion.getEntityType())) {
            rateDataBuilder = new FixRateDataBuilder(report2, (DatePeriod)period, now);
        } else if (Intrinsics.areEqual((Object)string, (Object)XdResolveRateReport.Companion.getEntityType())) {
            rateDataBuilder = new ResolveRateDataBuilder(report2, (DatePeriod)period, now);
        } else if (Intrinsics.areEqual((Object)string, (Object)XdVerifyRateReport.Companion.getEntityType())) {
            rateDataBuilder = new VerifyRateDataBuilder(report2, (DatePeriod)period, now);
        } else {
            throw (Throwable)new RuntimeException("Unknown rate report type: " + report2.getEntity().getType());
        }
        return rateDataBuilder.build(monitor);
    }
}

