/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.cache;

import java.util.Set;
import javax.ws.rs.WebApplicationException;
import jetbrains.charisma.main.CharismaLicenseChecker;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.ring.BeansKt;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.security.Role;
import jetbrains.jetpass.dao.api.permissionCache.PermissionCache;
import jetbrains.jetpass.dao.api.permissionCache.PermissionCacheListener;
import jetbrains.jetpass.rest.dto.PermissionJSON;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.RoleJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.sequence.Sequence;
import jetbrains.ring.license.LicenseFlag;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Permission;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\u000b"}, d2={"Ljetbrains/youtrack/ring/cache/GuestPermissionsChangeListener;", "Ljetbrains/jetpass/dao/api/permissionCache/PermissionCacheListener;", "()V", "cacheCalculated", "", "permissionCache", "Ljetbrains/jetpass/dao/api/permissionCache/PermissionCache;", "restoreGuestPermissions", "uuid", "", "Companion", "youtrack-ring-integration"})
public final class GuestPermissionsChangeListener
implements PermissionCacheListener {
    @NotNull
    public static final String ROLE_NAME = "Guest Issue Reader";
    public static final Companion Companion = new Companion(null);

    public void cacheCalculated(@NotNull PermissionCache permissionCache) {
        Intrinsics.checkParameterIsNotNull((Object)permissionCache, (String)"permissionCache");
        TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(this, permissionCache){
            final /* synthetic */ GuestPermissionsChangeListener this$0;
            final /* synthetic */ PermissionCache $permissionCache$inlined;
            {
                this.this$0 = guestPermissionsChangeListener;
                this.$permissionCache$inlined = permissionCache;
                super(1);
            }

            public final Unit invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                try {
                    Set guestPermissions;
                    String guestUuid;
                    if (ConfigurationUtil.isYoutrackHosted() && jetbrains.youtrack.config.BeansKt.getRingConfig().isEnabled() && CharismaLicenseChecker.checkFlag((LicenseFlag)LicenseFlag.BAN_GUEST_FORBIDDEN) && (guestUuid = BeansKt.getRingDataStore().getUserRingId(jetbrains.charisma.service.BeansKt.getUserService().checkGuest())) != null && !(guestPermissions = this.$permissionCache$inlined.user(guestUuid).toGlobalProject().getGrantedPermissions()).contains(BeansKt.getRingDataStore().getPermissionRingId(Permission.READ_ISSUE))) {
                        GuestPermissionsChangeListener.Companion.getLogger().info("Restoring guest read permissions for a free plan");
                        GuestPermissionsChangeListener.access$restoreGuestPermissions(this.this$0, guestUuid);
                    }
                }
                catch (WebApplicationException wae) {
                    GuestPermissionsChangeListener.Companion.getLogger().warn("Failed to restore guest permissions for a free instance: " + (String)wae.getResponse().readEntity(String.class), (Throwable)wae);
                }
                catch (Exception e) {
                    GuestPermissionsChangeListener.Companion.getLogger().warn("Guest permission check failed", (Throwable)e);
                }
                return Unit.INSTANCE;
            }
        }), (int)7, null);
    }

    private final void restoreGuestPermissions(String uuid2) {
        Role role;
        PermissionJSON permissionJSON = new PermissionJSON();
        permissionJSON.setId(BeansKt.getRingDataStore().getPermissionRingId(Permission.READ_ISSUE));
        Sequence hubRoles = jetbrains.youtrack.ring.client.BeansKt.getRingApi().getRoleDAO().getByName(ROLE_NAME);
        if (hubRoles.isEmpty()) {
            Companion.getLogger().debug("No guest issue reader role found, will create one");
            RoleJSON json = new RoleJSON();
            json.setName(ROLE_NAME);
            json.setDescription("Guest access has been automatically restored due to license limitations");
            json.setPermissions((Iterable)SetsKt.setOf((Object)permissionJSON));
            role = (Role)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getRoleDAO().create((IdItem)json);
        } else {
            Companion.getLogger().debug("Guest issue reader role found, will add to it to guest user");
            Object object = hubRoles.first();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            role = (Role)object;
            jetbrains.youtrack.ring.client.BeansKt.getRingApi().getRoleDAO().addPermission(role, (jetbrains.jetpass.api.security.Permission)permissionJSON);
        }
        ProjectRoleJSON projectRole = new ProjectRoleJSON();
        projectRole.setRole(new RoleJSON(role));
        projectRole.setProject(new ProjectJSON(jetbrains.youtrack.ring.client.BeansKt.getRingApi().getProjectDAO().getGlobal()));
        UserJSON updatedGuest = new UserJSON();
        updatedGuest.setId(uuid2);
        updatedGuest.setProjectRoles((Iterable)SetsKt.setOf((Object)projectRole));
        jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserDAO().update(uuid2, (IdItem)updatedGuest);
    }

    public static final /* synthetic */ void access$restoreGuestPermissions(GuestPermissionsChangeListener $this, @Nullable String uuid2) {
        $this.restoreGuestPermissions(uuid2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/youtrack/ring/cache/GuestPermissionsChangeListener$Companion;", "Lmu/KLogging;", "()V", "ROLE_NAME", "", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

