/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.client;

import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import jetbrains.youtrack.api.ring.HubClientFilter;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Ljetbrains/youtrack/ring/client/SlowRequestMonitoringFilter;", "Ljetbrains/youtrack/api/ring/HubClientFilter;", "()V", "handleRequest", "", "request", "Ljavax/ws/rs/client/ClientRequestContext;", "handleResponse", "response", "Ljavax/ws/rs/client/ClientResponseContext;", "Companion", "youtrack-ring-integration"})
public final class SlowRequestMonitoringFilter
implements HubClientFilter {
    @NotNull
    public static final String TIMESTAMP = "request_start_time";
    public static final Companion Companion = new Companion(null);

    public void handleRequest(@NotNull ClientRequestContext request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        request.setProperty(TIMESTAMP, (Object)System.currentTimeMillis());
    }

    public void handleResponse(@NotNull ClientRequestContext request, @NotNull ClientResponseContext response) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Object object = request.getProperty(TIMESTAMP);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
        }
        long reqTime = System.currentTimeMillis() - (Long)object;
        if (reqTime > (long)3000) {
            Companion.getLogger().warn("Request to Hub (" + request.getUri() + ") took " + reqTime + " ms");
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/youtrack/ring/client/SlowRequestMonitoringFilter$Companion;", "Lmu/KLogging;", "()V", "TIMESTAMP", "", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

