/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.auth.module.jira.rest.client.json.JiraauthmoduleJSON;
import jetbrains.jetpass.client.accounts.AuthModuleClient;
import jetbrains.jetpass.rest.dto.AuthmoduleJSON;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u000b"}, d2={"Ljetbrains/youtrack/ring/export/JiraProviderFactory;", "", "()V", "createNewAuthModuleJSON", "Ljetbrains/jetpass/rest/dto/AuthmoduleJSON;", "url", "", "getOrCreate", "client", "Ljetbrains/jetpass/client/accounts/AuthModuleClient;", "Companion", "youtrack-ring-integration"})
public final class JiraProviderFactory {
    @NotNull
    public static final String VOLFMAN_CONSTANT = "http://";
    @NotNull
    public static final String TYPE_NAME = "Atlassian Jira";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final AuthmoduleJSON getOrCreate(@NotNull AuthModuleClient client2) {
        Intrinsics.checkParameterIsNotNull((Object)client2, (String)"client");
        Object object = ServiceLocator.getBean((String)"jiraIntegrationSettings");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.Entity");
        }
        Entity settings = (Entity)object;
        return PrimitiveAssociationSemantics.get((Entity)settings, (String)"jiraUrl", String.class, null) == null || Intrinsics.areEqual((Object)VOLFMAN_CONSTANT, (Object)((String)PrimitiveAssociationSemantics.get((Entity)settings, (String)"jiraUrl", String.class, null))) ? null : this.getOrCreate(client2, (String)PrimitiveAssociationSemantics.get((Entity)settings, (String)"jiraUrl", String.class, null));
    }

    @Nullable
    public final AuthmoduleJSON getOrCreate(@NotNull AuthModuleClient client2, @Nullable String url) {
        AuthmoduleJSON authmoduleJSON;
        AuthmoduleJSON json;
        Intrinsics.checkParameterIsNotNull((Object)client2, (String)"client");
        Companion.getLogger().debug("Try to find Atlassian Jira Hub auth module for url: " + url);
        if (url != null && (json = client2.getAuthModuleByUrl(url, null)) != null) {
            Companion.getLogger().debug("Module Atlassian Jira for url: " + url + " found. Provider type: " + json.getClass().getSimpleName());
            return json;
        }
        Companion.getLogger().info("Creating Atlassian Jira Hub auth module for url: " + url);
        json = this.createNewAuthModuleJSON(url);
        String failHeader = "Failed to create Atlassian Jira";
        try {
            AuthmoduleJSON authmoduleJSON2 = json;
            if (authmoduleJSON2 == null) {
                Intrinsics.throwNpe();
            }
            authmoduleJSON = client2.createAuthModule(authmoduleJSON2, null);
        }
        catch (WebApplicationException ex) {
            KLogger kLogger = Companion.getLogger();
            StringBuilder stringBuilder = new StringBuilder().append(failHeader).append(" code: ");
            Response response = ex.getResponse();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ex.response");
            kLogger.warn(stringBuilder.append(response.getStatus()).append(". See more in Hub logs").toString(), (Throwable)ex);
            authmoduleJSON = null;
        }
        json = authmoduleJSON;
        if (json != null) {
            Companion.getLogger().info("Module Atlassian Jira created with id " + json.getId());
        } else {
            Companion.getLogger().warn(failHeader + " for url: " + url);
        }
        return json;
    }

    private final AuthmoduleJSON createNewAuthModuleJSON(String url) {
        JiraauthmoduleJSON jira = new JiraauthmoduleJSON();
        jira.setName("Atlassian Jira " + url);
        jira.setServerUrl(url);
        jira.setName(TYPE_NAME);
        return (AuthmoduleJSON)jira;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/ring/export/JiraProviderFactory$Companion;", "Lmu/KLogging;", "()V", "TYPE_NAME", "", "VOLFMAN_CONSTANT", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

