/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export.adapter;

import java.util.Collection;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.authority.ProjectTeam;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.ProjectTeamClient;
import jetbrains.jetpass.client.accounts.UserGroupClient;
import jetbrains.jetpass.dao.remote.api.authority.RemoteUserGroupDAO;
import jetbrains.jetpass.pojo.api.authority.UserGroupImpl;
import jetbrains.jetpass.rest.dto.ProjectTeamJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.youtrack.api.ring.HubExportResult;
import jetbrains.youtrack.persistent.XdUserGroup;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.export.BeansKt;
import jetbrains.youtrack.ring.export.FailureExportResult;
import jetbrains.youtrack.ring.export.SuccessExportResult;
import jetbrains.youtrack.ring.export.adapter.XdEntityHubSyncAdapter;
import jetbrains.youtrack.ring.export.dto.HubDtoBuilder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Ljetbrains/youtrack/ring/export/adapter/GroupHubSyncAdapter;", "Ljetbrains/youtrack/ring/export/adapter/XdEntityHubSyncAdapter;", "Ljetbrains/youtrack/persistent/XdUserGroup;", "dtoBuilder", "Ljetbrains/youtrack/ring/export/dto/HubDtoBuilder;", "Ljetbrains/jetpass/rest/dto/UserGroupJSON;", "(Ljetbrains/youtrack/ring/export/dto/HubDtoBuilder;)V", "groupClient", "Ljetbrains/jetpass/client/accounts/UserGroupClient;", "getGroupClient", "()Ljetbrains/jetpass/client/accounts/UserGroupClient;", "teamsClient", "Ljetbrains/jetpass/client/accounts/ProjectTeamClient;", "getTeamsClient", "()Ljetbrains/jetpass/client/accounts/ProjectTeamClient;", "add", "Ljetbrains/youtrack/api/ring/HubExportResult;", "youtrackEntity", "linkExistingGroup", "group", "hubGroup", "Ljetbrains/jetpass/api/authority/UserGroup;", "linkExistingTeam", "hubTeam", "Ljetbrains/jetpass/api/authority/ProjectTeam;", "remove", "", "update", "youtrack-ring-integration"})
public final class GroupHubSyncAdapter
extends XdEntityHubSyncAdapter<XdUserGroup> {
    private final HubDtoBuilder<XdUserGroup, UserGroupJSON> dtoBuilder;

    private final UserGroupClient getGroupClient() {
        return jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getUserGroupClient();
    }

    private final ProjectTeamClient getTeamsClient() {
        return jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClientWithLongTimeouts().getProjectTeamClient();
    }

    @Override
    @NotNull
    public HubExportResult add(@NotNull XdUserGroup youtrackEntity) {
        Exception exception;
        block9: {
            Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
            try {
                HubExportResult hubExportResult;
                if (youtrackEntity.getAllUsersGroup()) {
                    hubExportResult = this.linkExistingGroup(youtrackEntity, jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserGroupDAO().getRootUserGroup());
                } else {
                    UserGroupJSON json = this.dtoBuilder.build(youtrackEntity);
                    String string = this.getGroupClient().createUserGroup(json, null).getId();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"groupClient.createUserGroup(json, null).id!!");
                    String id2 = string;
                    EntityExtensionsKt.setHubUuid((XdEntity)youtrackEntity, id2);
                    EntityExtensionsKt.markAsRegularGroup(youtrackEntity);
                    hubExportResult = new SuccessExportResult(id2, "User group " + youtrackEntity.getName() + " exported into Hub");
                }
                return hubExportResult;
            }
            catch (WebApplicationException e) {
                Object v3;
                block10: {
                    exception = (Exception)((Object)e);
                    Response response = e.getResponse();
                    Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"e.response");
                    if (response.getStatus() != 409) break block9;
                    Filter groupFilter = (Filter)new Filter(null, 1, null).query("name: {" + youtrackEntity.getName() + '}');
                    List groups = this.getGroupClient().getUserGroupPage((BaseFilter)groupFilter, null).getItems();
                    Collection collection = groups;
                    if (!collection.isEmpty()) {
                        return this.linkExistingGroup(youtrackEntity, (UserGroup)CollectionsKt.first((List)groups));
                    }
                    Filter teamFilter = (Filter)new Filter(null, 1, null).top(10000);
                    List teams = this.getTeamsClient().getProjectTeamPage((BaseFilter)teamFilter, null).getItems();
                    Iterable $receiver$iv = teams;
                    for (Object element$iv : $receiver$iv) {
                        ProjectTeamJSON it = (ProjectTeamJSON)element$iv;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)youtrackEntity.getName())) continue;
                        v3 = element$iv;
                        break block10;
                    }
                    v3 = null;
                }
                ProjectTeamJSON team = v3;
                if (team != null) {
                    return this.linkExistingTeam(youtrackEntity, (ProjectTeam)team);
                }
            }
            catch (Exception e) {
                exception = e;
            }
        }
        return new FailureExportResult("Following user group cannot be exported to Hub: " + youtrackEntity.getName(), exception);
    }

    private final HubExportResult linkExistingGroup(XdUserGroup group2, UserGroup hubGroup) {
        String ringId = hubGroup.getId();
        for (ProjectRole projectRole : BeansKt.getRoleJsonBuilder().toHubProjectRoles(XdQueryKt.toList((XdQuery)((XdQuery)group2.getGroupRoles())))) {
            RemoteUserGroupDAO remoteUserGroupDAO = jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserGroupDAO();
            String string = ringId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ringId");
            remoteUserGroupDAO.addRole(string, projectRole);
        }
        EntityExtensionsKt.setHubUuid((XdEntity)group2, ringId);
        EntityExtensionsKt.markAsRegularGroup(group2);
        UserGroupImpl groupImpl = new UserGroupImpl();
        groupImpl.setName(group2.getName());
        groupImpl.setDescription(group2.getDescription());
        jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserGroupDAO().update(ringId, (IdItem)groupImpl);
        String string = ringId;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ringId");
        return new SuccessExportResult(string, "User group " + group2.getName() + " linked to Hub user group " + hubGroup.getName());
    }

    private final HubExportResult linkExistingTeam(XdUserGroup group2, ProjectTeam hubTeam) {
        EntityExtensionsKt.setHubUuid((XdEntity)group2, hubTeam.getId());
        Project project = hubTeam.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"hubTeam.project");
        String string = project.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hubTeam.project.id");
        EntityExtensionsKt.markAsTeam(group2, string);
        String string2 = hubTeam.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"hubTeam.id");
        return new SuccessExportResult(string2, "User group " + group2.getName() + " linked to Hub project team " + hubTeam.getName());
    }

    @Override
    public void update(@NotNull XdUserGroup youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        if (!EntityExtensionsKt.isTeam(youtrackEntity)) {
            jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserGroupDAO().update(EntityExtensionsKt.getHubUuidNotNull((XdEntity)youtrackEntity), (IdItem)this.dtoBuilder.build(youtrackEntity));
        }
    }

    @Override
    public void remove(@NotNull XdUserGroup youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        if (EntityExtensionsKt.isTeam(youtrackEntity)) {
            throw (Throwable)new IllegalStateException(youtrackEntity.getName() + " is a project team and cannot be removed directly");
        }
        jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserGroupDAO().delete(EntityExtensionsKt.getHubUuidNotNull((XdEntity)youtrackEntity));
    }

    public GroupHubSyncAdapter(@NotNull HubDtoBuilder<? super XdUserGroup, ? extends UserGroupJSON> dtoBuilder) {
        Intrinsics.checkParameterIsNotNull(dtoBuilder, (String)"dtoBuilder");
        this.dtoBuilder = dtoBuilder;
    }
}

