/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export.adapter;

import com.intellij.hub.core.data.uri.DataURI;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.WebApplicationException;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.AuthModuleClient;
import jetbrains.jetpass.client.accounts.SettingClient;
import jetbrains.jetpass.rest.dto.AuthmoduleJSON;
import jetbrains.jetpass.rest.dto.LocaleJSON;
import jetbrains.jetpass.rest.dto.PublicSettingsJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import jetbrains.youtrack.api.ring.HubExportResult;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.persistent.XdApplicationMetaData;
import jetbrains.youtrack.persistent.XdPersistentImageFile;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.export.FailureExportResult;
import jetbrains.youtrack.ring.export.SuccessExportResult;
import jetbrains.youtrack.ring.export.adapter.XdEntityHubSyncAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0002H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Ljetbrains/youtrack/ring/export/adapter/MetaDataHubSyncAdapter;", "Ljetbrains/youtrack/ring/export/adapter/XdEntityHubSyncAdapter;", "Ljetbrains/youtrack/persistent/XdApplicationMetaData;", "()V", "authModuleClient", "Ljetbrains/jetpass/client/accounts/AuthModuleClient;", "getAuthModuleClient", "()Ljetbrains/jetpass/client/accounts/AuthModuleClient;", "settingsClient", "Ljetbrains/jetpass/client/accounts/SettingClient;", "getSettingsClient", "()Ljetbrains/jetpass/client/accounts/SettingClient;", "add", "Ljetbrains/youtrack/api/ring/HubExportResult;", "youtrackEntity", "remove", "", "update", "updateLocaleAndLogoSettings", "config", "Companion", "youtrack-ring-integration"})
public final class MetaDataHubSyncAdapter
extends XdEntityHubSyncAdapter<XdApplicationMetaData> {
    public static final Companion Companion = new Companion(null);

    private final AuthModuleClient getAuthModuleClient() {
        return jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClientWithLongTimeouts().getAuthModuleClient();
    }

    private final SettingClient getSettingsClient() {
        return jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClientWithLongTimeouts().getSettingsClient();
    }

    @Override
    @NotNull
    public HubExportResult add(@NotNull XdApplicationMetaData youtrackEntity) {
        HubExportResult hubExportResult;
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        Filter filter = (Filter)new Filter(null, 1, null).query("type: {Build-in Authorization}");
        List coreAuthModules = this.getAuthModuleClient().getAuthModulePage((BaseFilter)filter, null).getAuthmodules();
        if (coreAuthModules.isEmpty()) {
            hubExportResult = new FailureExportResult("Can't locate built-in authorization module in Hub", new IllegalStateException());
        } else {
            String string = ((AuthmoduleJSON)coreAuthModules.get(0)).getId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"coreAuthModules[0].id!!");
            String ringId = string;
            EntityExtensionsKt.setHubUuid((XdEntity)youtrackEntity, ringId);
            this.updateLocaleAndLogoSettings(youtrackEntity);
            hubExportResult = new SuccessExportResult(ringId, "Application metadata synchronized with Hub");
        }
        return hubExportResult;
    }

    @Override
    public void update(@NotNull XdApplicationMetaData youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        this.updateLocaleAndLogoSettings(youtrackEntity);
    }

    private final void updateLocaleAndLogoSettings(XdApplicationMetaData config) {
        String hubMessage;
        PublicSettingsJSON json;
        Filter filter = (Filter)new Filter(null, 1, null).query("type: public");
        List settings = this.getSettingsClient().getSettingPage((BaseFilter)filter, null).getItems();
        if (settings.isEmpty()) {
            throw (Throwable)new IllegalStateException("Hub returned no Settings for type 'public', skipping locale and logo sync");
        }
        String string = ((SettingsJSON)settings.get(0)).getId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"settings[0].id!!");
        String id2 = string;
        if (BeansKt.getRingConfig().hasEmbeddedHub()) {
            try {
                Locale locale = ApplicationMetaDataImpl.getLocale();
                json = new PublicSettingsJSON();
                LocaleJSON localeJson = new LocaleJSON();
                json.setId(id2);
                localeJson.setName(locale.toString());
                Locale locale2 = locale;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"locale");
                localeJson.setRegion(locale2.getCountry());
                localeJson.setLanguage(locale.getLanguage());
                json.setLocale(localeJson);
                this.getSettingsClient().updateSetting(id2, (SettingsJSON)json);
            }
            catch (WebApplicationException e) {
                hubMessage = (String)e.getResponse().readEntity(String.class);
                Companion.getLogger().warn(hubMessage, (Throwable)e);
                jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Got error while exporting locale data into Hub: " + e.getMessage() + ' ' + hubMessage);
            }
            catch (Exception e) {
                jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Hub is not able to switch locale to " + ApplicationMetaDataImpl.getLocale(), e);
            }
        }
        try {
            XdPersistentImageFile logo = config.getLogo();
            json = new PublicSettingsJSON();
            json.setId(id2);
            if (logo == null) {
                json.setCompanyLogo("");
            } else {
                String string2 = logo.getMimeType();
                if (string2 == null) {
                    string2 = "image/png";
                }
                InputStream inputStream = logo.getContent();
                if (inputStream == null) {
                    Intrinsics.throwNpe();
                }
                json.setCompanyLogo(new DataURI(string2, inputStream).getDataURI());
            }
            json.setHubMottoHidden(Boolean.valueOf(true));
            this.getSettingsClient().updateSetting(id2, (SettingsJSON)json);
        }
        catch (WebApplicationException e) {
            hubMessage = (String)e.getResponse().readEntity(String.class);
            Companion.getLogger().warn(hubMessage, (Throwable)e);
            jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Got error while exporting custom logo into Hub: " + e.getMessage());
        }
        catch (Exception e) {
            jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Failed to update custom logo in Hub", e);
        }
    }

    @Override
    public void remove(@NotNull XdApplicationMetaData youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        throw (Throwable)new UnsupportedOperationException("Application metadata cannot be removed");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/export/adapter/MetaDataHubSyncAdapter$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

