/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.impl;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.ring.BeansKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.PropertyNotNull;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.jetpass.api.authority.ProjectTeam;
import jetbrains.jetpass.api.security.Project;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.api.ring.RingTeamApi;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUserGroup;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.sync.RingTeam;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component(value="ringTeamApi")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Ljetbrains/youtrack/ring/impl/RingTeamApiImpl;", "Ljetbrains/youtrack/api/ring/RingTeamApi;", "()V", "excludeTeamGroups", "", "Ljetbrains/exodus/entitystore/Entity;", "groups", "getProjectTeam", "project", "getProjectTeamAsQuery", "getTeamProject", "group", "isTeamMember", "", "user", "resolveTeam", "uuid", "", "Companion", "youtrack-ring-integration"})
public final class RingTeamApiImpl
implements RingTeamApi {
    public static final Companion Companion = new Companion(null);

    public boolean isTeamMember(@NotNull Entity user2, @NotNull Entity project) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String hubUserId = EntityExtensionsKt.getHubUuid(user2);
        if (hubUserId != null) {
            ProjectTeam team;
            Project project2 = (Project)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getProjectDAO().get(BeansKt.getRingDataStore().getProjectRingId(project));
            Object object = team = project2 != null ? project2.getTeam() : null;
            if (team != null) {
                Iterable iterable = team.getUsers();
                Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"team.users");
                return CollectionsKt.contains((Iterable)iterable, (Object)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserDAO().get(hubUserId));
            }
        } else {
            Companion.getLogger().warn("User " + user2 + " is not exported to Hub");
        }
        return false;
    }

    @NotNull
    public Entity resolveTeam(@NotNull String uuid2) {
        Intrinsics.checkParameterIsNotNull((Object)uuid2, (String)"uuid");
        Entity group2 = QueryOperations.getFirst((Iterable)((Iterable)QueryOperations.query(null, (String)"UserGroup", (NodeBase)((NodeBase)new PropertyEqual("$$hubId$$", (Comparable)((Object)uuid2))))));
        if (jetbrains.youtrack.config.BeansKt.getRingConfig().isEnabled() && EntityOperations.equals((Entity)group2, null)) {
            ProjectTeam team;
            ProjectTeam projectTeam = team = (ProjectTeam)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getProjectTeamDAO().get(uuid2);
            if (projectTeam == null) {
                Intrinsics.throwNpe();
            }
            XdUserGroup xdUserGroup = new RingTeam(projectTeam).resolveAndSync();
            group2 = xdUserGroup != null ? xdUserGroup.getEntity() : null;
        }
        Entity entity = group2;
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"group");
        return entity;
    }

    @Nullable
    public Entity getTeamProject(@NotNull Entity group2) {
        Intrinsics.checkParameterIsNotNull((Object)group2, (String)"group");
        XdProject xdProject = EntityExtensionsKt.getTeamHubProject((XdUserGroup)XdExtensionsKt.toXd((Entity)group2));
        return xdProject != null ? xdProject.getEntity() : null;
    }

    @Nullable
    public Entity getProjectTeam(@NotNull Entity project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        XdUserGroup xdUserGroup = EntityExtensionsKt.getTeamGroup((XdProject)XdExtensionsKt.toXd((Entity)project));
        return xdUserGroup != null ? xdUserGroup.getEntity() : null;
    }

    @NotNull
    public Iterable<Entity> getProjectTeamAsQuery(@NotNull Entity project) {
        Iterable iterable;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String id2 = jetbrains.youtrack.ring.sync.BeansKt.getHubUuidCache().getProjectId(project);
        if (id2 == null || (charSequence = (CharSequence)id2).length() == 0) {
            Iterable iterable2 = QueryOperations.empty((String)"UserGroup");
            iterable = iterable2;
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"QueryOperations.empty(\"UserGroup\")");
        } else {
            TreeKeepingEntityIterable treeKeepingEntityIterable = QueryOperations.query((String)"UserGroup", (NodeBase)((NodeBase)new PropertyEqual("$$teamForProject$$", (Comparable)((Object)id2))));
            Intrinsics.checkExpressionValueIsNotNull((Object)treeKeepingEntityIterable, (String)"QueryOperations.query(\"U\u2026al(TEAM_FOR_PROJECT, id))");
            iterable = (Iterable)treeKeepingEntityIterable;
        }
        return iterable;
    }

    @NotNull
    public Iterable<Entity> excludeTeamGroups(@NotNull Iterable<? extends Entity> groups) {
        Intrinsics.checkParameterIsNotNull(groups, (String)"groups");
        TreeKeepingEntityIterable treeKeepingEntityIterable = QueryOperations.query(groups, (String)"UserGroup", (NodeBase)((NodeBase)new UnaryNot((NodeBase)new PropertyNotNull("$$teamForProject$$"))));
        Intrinsics.checkExpressionValueIsNotNull((Object)treeKeepingEntityIterable, (String)"QueryOperations.query(gr\u2026tNull(TEAM_FOR_PROJECT)))");
        return (Iterable)treeKeepingEntityIterable;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/impl/RingTeamApiImpl$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

