/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.listeners.hub;

import com.intellij.hub.core.data.uri.DataURI;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.api.event.Event;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.youtrack.persistent.XdPersistentFile;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.persistent.XdUserGroup;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.cache.HubUuidCache;
import jetbrains.youtrack.ring.export.BeansKt;
import jetbrains.youtrack.ring.export.dto.ExportGroupHubDtoBuilder;
import jetbrains.youtrack.ring.listeners.hub.FilteringHubEventListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/ring/listeners/hub/ProjectHubEventListener;", "Ljetbrains/youtrack/ring/listeners/hub/FilteringHubEventListener;", "Ljetbrains/jetpass/api/security/Project;", "()V", "handleRemoved", "", "event", "Ljetbrains/jetpass/api/event/Event;", "handleUpdated", "youtrack-ring-integration"})
public final class ProjectHubEventListener
extends FilteringHubEventListener<Project> {
    /*
     * WARNING - void declaration
     */
    @Override
    protected void handleUpdated(@NotNull Event event) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        jetbrains.youtrack.ring.sync.BeansKt.getHubUuidCache().recalculate();
        Project hubProject = (Project)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getProjectDAO().get(event.getTargetId());
        HubUuidCache hubUuidCache = jetbrains.youtrack.ring.sync.BeansKt.getHubUuidCache();
        String string = event.getTargetId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.targetId");
        Iterable $receiver$iv = hubUuidCache.getProjects(string);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Entity entity = (Entity)item$iv$iv;
            Collection collection = destination$iv$iv;
            XdProject xdProject = (XdProject)XdExtensionsKt.toXd((Entity)it);
            collection.add(xdProject);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            XdProject project = (XdProject)element$iv;
            Project project2 = hubProject;
            if (project2 == null) {
                Intrinsics.throwNpe();
            }
            Boolean bl = project2.isArchived();
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"hubProject!!.isArchived");
            project.setArchived(bl.booleanValue());
            if (hubProject.getIcon() != null) {
                String string2 = hubProject.getIcon();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"hubProject.icon");
                DataURI dataURI = new DataURI(string2);
                project.setIcon((XdPersistentFile)XdPersistentFile.Companion.new((Function1)new Function1<XdPersistentFile, Unit>(dataURI){
                    final /* synthetic */ DataURI $dataURI;

                    public final void invoke(@NotNull XdPersistentFile $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        $receiver.setContent((InputStream)new ByteArrayInputStream(this.$dataURI.getContent()));
                        $receiver.setName("project.img");
                        $receiver.setMimeType(this.$dataURI.getMimeType());
                    }
                    {
                        this.$dataURI = dataURI;
                        super(1);
                    }
                }));
            }
            project.setDescription(hubProject.getDescription());
            if (hubProject.isGlobal().booleanValue()) continue;
            XdUserGroup xdUserGroup = EntityExtensionsKt.getTeamGroup(project);
            if (xdUserGroup == null) continue;
            xdUserGroup.setName(project.getName() + " Team");
        }
    }

    @Override
    protected void handleRemoved(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        String string = event.getTargetId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.targetId");
        XdUserGroup group2 = EntityExtensionsKt.findTeamByProjectUuid(XdUserGroup.Companion, string);
        if (group2 != null) {
            if (jetbrains.charisma.service.BeansKt.getUserGroupService().hasUsages(group2.getEntity())) {
                EntityExtensionsKt.setHubUuid((XdEntity)group2, (String)null);
                BeansKt.getHubAdapterFactory().getGroupAdapter(new ExportGroupHubDtoBuilder(){

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public UserGroupJSON build(@NotNull XdUserGroup entity) {
                        Collection<UserJSON> collection;
                        void $receiver$iv$iv;
                        void $receiver$iv;
                        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
                        UserGroupJSON json = super.build(entity);
                        Iterable iterable = XdQueryKt.toList((XdQuery)((XdQuery)entity.getUsers()));
                        UserGroupJSON userGroupJSON = json;
                        void var4_5 = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (T item$iv$iv : $receiver$iv$iv) {
                            void user2;
                            XdUser xdUser = (XdUser)item$iv$iv;
                            collection = destination$iv$iv;
                            UserJSON userJson = new UserJSON();
                            userJson.setId(EntityExtensionsKt.getHubUuid((XdEntity)user2));
                            UserJSON userJSON = userJson;
                            collection.add(userJSON);
                        }
                        collection = (List)destination$iv$iv;
                        userGroupJSON.setUsers((Iterable)collection);
                        return json;
                    }
                }).add(group2);
            } else {
                group2.delete();
            }
        }
    }

    public ProjectHubEventListener() {
        super(true);
    }
}

