/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.refactoring;

import java.util.List;
import jetbrains.jetpass.api.security.Role;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.RoleClient;
import jetbrains.jetpass.rest.dto.PermissionJSON;
import jetbrains.jetpass.rest.dto.RoleJSON;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.XdApplicationMetaData;
import jetbrains.youtrack.refactoring.XdRefactoring;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.client.BeansKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Ljetbrains/youtrack/ring/refactoring/RefactoringSupportLowLevelReadAdminPermission;", "Ljetbrains/youtrack/refactoring/XdRefactoring;", "()V", "apply", "", "meta", "Ljetbrains/youtrack/persistent/XdApplicationMetaData;", "getName", "", "Companion", "youtrack-ring-integration"})
public final class RefactoringSupportLowLevelReadAdminPermission
extends XdRefactoring {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getName() {
        return "Assign low level read admin permision to those who have low level admin";
    }

    public void apply(@NotNull XdApplicationMetaData meta) {
        Intrinsics.checkParameterIsNotNull((Object)meta, (String)"meta");
        try {
            RoleClient client2 = BeansKt.getHubClient().getAccountsClient().getRoleClient();
            Filter filter = new Filter(null, 1, null);
            filter.query("permission: " + EntityExtensionsKt.getHubUuid(Permission.ADMIN_UPDATE_APP));
            List roles = client2.getRolePage((BaseFilter)filter, null).getItems();
            for (RoleJSON role : roles) {
                PermissionJSON permission2 = new PermissionJSON();
                permission2.setId(EntityExtensionsKt.getHubUuid(Permission.ADMIN_READ_APP));
                BeansKt.getRingApi().getRoleDAO().addPermission((Role)role, (jetbrains.jetpass.api.security.Permission)permission2);
            }
            this.markApplied();
        }
        catch (Exception e) {
            Companion.getLogger().warn("Admin read permission cannot be applied", (Throwable)e);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/refactoring/RefactoringSupportLowLevelReadAdminPermission$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

