/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.refactoring;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.UserClient;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.persistent.XdApplicationMetaData;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdProjectPinKt;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.refactoring.XdRefactoring;
import jetbrains.youtrack.ring.refactoring.RefactoringSyncProjectPinStatus;
import jetbrains.youtrack.ring.refactoring.RingRefactoringUtilKt;
import jetbrains.youtrack.ring.sync.RingUser;
import jetbrains.youtrack.ring.sync.RingUserResolver;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component(value="refactoringSyncProjectPinStatus")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0002J\b\u0010\b\u001a\u00020\u0004H\u0002J+\u0010\t\u001a\u00020\u00042!\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0002\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/ring/refactoring/RefactoringSyncProjectPinStatus;", "Ljetbrains/youtrack/refactoring/XdRefactoring;", "()V", "apply", "", "meta", "Ljetbrains/youtrack/persistent/XdApplicationMetaData;", "migrateHubFavoriteToYouTrack", "migrateYouTrackPinToHub", "processPages", "process", "Lkotlin/Function1;", "Ljetbrains/jetpass/client/accounts/UserClient$Page;", "Lkotlin/ParameterName;", "name", "it", "updateUserBatch", "", "batch", "Companion", "youtrack-ring-integration"})
public class RefactoringSyncProjectPinStatus
extends XdRefactoring {
    public static final Companion Companion = new Companion(null);

    public void apply(@NotNull XdApplicationMetaData meta) {
        Intrinsics.checkParameterIsNotNull((Object)meta, (String)"meta");
        if (BeansKt.getRingConfig().hasEmbeddedHub()) {
            this.migrateYouTrackPinToHub();
        } else {
            this.migrateHubFavoriteToYouTrack();
        }
        this.markApplied();
    }

    private final void processPages(Function1<? super UserClient.Page, Unit> process) {
        int skip = 0;
        int batchSize = 250;
        Filter filter = (Filter)new Filter(null, 1, null).top(batchSize);
        while (true) {
            filter.skip(skip);
            UserClient.Page page = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getUserClient().getUserPage((BaseFilter)filter, (FieldPartial)RingUser.Companion.getSYNC_PARTIAL());
            if (page.getUsers().size() <= 0) break;
            process.invoke((Object)page);
            Companion.getLogger().info("Updating favorite projects. " + (skip += page.getUsers().size()) + " users processed");
            filter.skip(skip);
        }
    }

    private final void migrateHubFavoriteToYouTrack() {
        this.processPages((Function1<? super UserClient.Page, Unit>)((Function1)migrateHubFavoriteToYouTrack.1.INSTANCE));
    }

    private final void migrateYouTrackPinToHub() {
        RingRefactoringUtilKt.startJob(this, new Runnable(this){
            final /* synthetic */ RefactoringSyncProjectPinStatus this$0;

            public final void run() {
                try {
                    RefactoringSyncProjectPinStatus.access$processPages(this.this$0, (Function1)new Function1<UserClient.Page, Unit>(this){
                        final /* synthetic */ migrateYouTrackPinToHub.1 this$0;

                        public final void invoke(@NotNull UserClient.Page it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            long batchUpdateTime = RefactoringSyncProjectPinStatus.access$updateUserBatch(this.this$0.this$0, it);
                            Thread.sleep(batchUpdateTime);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    });
                }
                catch (Exception exception) {
                    RefactoringSyncProjectPinStatus.Companion.getLogger().warn("", (Throwable)exception);
                }
            }
            {
                this.this$0 = refactoringSyncProjectPinStatus;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final long updateUserBatch(UserClient.Page batch) {
        long startTime = System.currentTimeMillis();
        for (UserJSON user2 : batch.getUsers()) {
            Object it;
            void $receiver$iv$iv;
            XdUser ytUser;
            RingUserResolver ringUserResolver = jetbrains.youtrack.ring.sync.BeansKt.getHubUserResolver();
            String string = user2.getId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"user.id!!");
            if (ringUserResolver.resolve(string) == null) {
                continue;
            }
            List pinned = XdQueryKt.toList((XdQuery)XdProjectPinKt.getPinnedProjects((XdUser)ytUser));
            Object object = user2.getFavoriteProjects();
            if (object == null) continue;
            Iterable $receiver$iv = object;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
            Iterator iterator2 = $receiver$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            for (Object element$iv$iv : $receiver$iv$iv) {
                String string2;
                ProjectJSON projectJSON = (ProjectJSON)element$iv$iv;
                Map map = destination$iv$iv;
                void v3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                if (v3.getId() == null) {
                    Intrinsics.throwNpe();
                }
                map.put(string2, element$iv$iv);
            }
            object = MapsKt.toMutableMap((Map)destination$iv$iv);
            if (object == null) {
                continue;
            }
            Object favorite = object;
            try {
                Object it2;
                UserClient userClient = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getUserClient();
                String string3 = user2.getId();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"user.id!!");
                UserClient.FavoriteProjectClient client2 = userClient.getFavoriteProjectsClient(string3);
                Iterable $receiver$iv2 = pinned;
                for (Object element$iv : $receiver$iv2) {
                    it2 = (XdProject)element$iv;
                    String hubProjectId = jetbrains.youtrack.ring.sync.BeansKt.getHubUuidCache().getProjectId(it2.getEntity());
                    Object object2 = it = favorite;
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                    }
                    if (!object2.containsKey(hubProjectId)) {
                        it = new ProjectJSON();
                        UserClient.FavoriteProjectClient favoriteProjectClient = client2;
                        Object $receiver = it;
                        $receiver.setId(hubProjectId);
                        Object object3 = it;
                        favoriteProjectClient.addFavoriteProject((ProjectJSON)object3, null);
                    }
                    Object object4 = it = favorite;
                    if (object4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
                    }
                    TypeIntrinsics.asMutableMap((Object)object4).remove(hubProjectId);
                }
                $receiver$iv2 = favorite.keySet();
                for (Object element$iv : $receiver$iv2) {
                    Object object5 = it2 = (String)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"it");
                    client2.removeFavoriteProject((String)object5);
                }
            }
            catch (WebApplicationException e) {
                Response response = e.getResponse();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"e.response");
                if (response.getStatus() == 404) {
                    Companion.getLogger().warn("Unable to post user " + ytUser.getLogin() + " to Hub due to broken mapping");
                    continue;
                }
                Companion.getLogger().warn("Unable to post user " + ytUser.getLogin() + " to Hub, skipping", (Throwable)e);
            }
        }
        return System.currentTimeMillis() - startTime;
    }

    public static final /* synthetic */ void access$processPages(RefactoringSyncProjectPinStatus $this, @NotNull Function1 process) {
        $this.processPages((Function1<? super UserClient.Page, Unit>)process);
    }

    public static final /* synthetic */ long access$updateUserBatch(RefactoringSyncProjectPinStatus $this, @NotNull UserClient.Page batch) {
        return $this.updateUserBatch(batch);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/refactoring/RefactoringSyncProjectPinStatus$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

