/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.sync;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import jetbrains.charisma.service.BeansKt;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.ring.sync.MergeMarkerExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\b\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J\u0016\u0010\u0007\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J\u0014\u0010\b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006J\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/ring/sync/RingUserMerger;", "", "()V", "findHolyCow", "Ljetbrains/youtrack/persistent/XdUser;", "users", "", "findOptimalMergeTarget", "merge", "all", "performMerge", "target", "victims", "Companion", "youtrack-ring-integration"})
public final class RingUserMerger {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final XdUser merge(@NotNull Iterable<? extends XdUser> all) {
        XdUser xdUser;
        Intrinsics.checkParameterIsNotNull(all, (String)"all");
        XdUser holyCow = this.findHolyCow(all);
        if (holyCow != null) {
            xdUser = this.performMerge(holyCow, CollectionsKt.minus(all, (Object)holyCow));
        } else {
            XdUser bestMatch = this.findOptimalMergeTarget(all);
            xdUser = this.performMerge(bestMatch, CollectionsKt.minus(all, (Object)bestMatch));
        }
        return xdUser;
    }

    private final XdUser performMerge(XdUser target, Iterable<? extends XdUser> victims) {
        for (XdUser xdUser : victims) {
            if (MergeMarkerExtensionsKt.shouldBeMerged((XdEntity)xdUser)) {
                Companion.getLogger().info("Merging user " + xdUser.getLogin() + " into " + target.getLogin());
                BeansKt.getUserService().merge(xdUser.getEntity(), target.getEntity());
                continue;
            }
            if (MergeMarkerExtensionsKt.shouldBeDeleted((XdEntity)xdUser)) {
                Companion.getLogger().info("Removing user " + xdUser.getLogin() + " with a successor " + target.getLogin());
                BeansKt.getUserService().deleteWithSuccessor(xdUser.getEntity(), target.getEntity());
                continue;
            }
            Companion.getLogger().warn("User " + xdUser.getLogin() + " has been selected for merge, but has no active merge marker");
        }
        MergeMarkerExtensionsKt.clearMergeMarker((XdEntity)target);
        return target;
    }

    private final XdUser findHolyCow(Iterable<? extends XdUser> users) {
        XdUser xdUser;
        block1: {
            Iterable<? extends XdUser> $receiver$iv = users;
            for (XdUser xdUser2 : $receiver$iv) {
                XdUser it = xdUser2;
                if (!(it.isGuest() || it.getRoot())) continue;
                xdUser = xdUser2;
                break block1;
            }
            xdUser = null;
        }
        return xdUser;
    }

    /*
     * WARNING - void declaration
     */
    private final XdUser findOptimalMergeTarget(Iterable<? extends XdUser> users) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = users;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            XdUser it = (XdUser)element$iv$iv;
            if (!(!MergeMarkerExtensionsKt.shouldBeDeleted((XdEntity)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        iterable = $receiver$iv;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                XdUser user2 = (XdUser)a;
                Function2<FilteringContext, XdIssue, Unit> function2 = new Function2<FilteringContext, XdIssue, Unit>(user2){
                    final /* synthetic */ XdUser $user;
                    {
                        this.$user = xdUser;
                        super(2);
                    }

                    public final void invoke(@NotNull FilteringContext $receiver, @NotNull XdIssue it) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        $receiver.eq((XdEntity)it.getReporter(), (XdEntity)this.$user);
                    }
                };
                user2 = (XdUser)b;
                Comparable comparable = Integer.valueOf(XdQueryKt.size((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdIssue.Companion.all(), (Function2)((Function2)function2))));
                Integer n = XdQueryKt.size((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdIssue.Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdIssue, Unit>(user2){
                    final /* synthetic */ XdUser $user;
                    {
                        this.$user = xdUser;
                        super(2);
                    }

                    public final void invoke(@NotNull FilteringContext $receiver, @NotNull XdIssue it) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        $receiver.eq((XdEntity)it.getReporter(), (XdEntity)this.$user);
                    }
                })));
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        };
        return (XdUser)CollectionsKt.last((List)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator));
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/sync/RingUserMerger$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

