/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.sync.service;

import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.UriBuilder;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.BaseAccountsClient;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.ring.sync.service.RingService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@LocalScoped
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u001b"}, d2={"Ljetbrains/youtrack/ring/sync/service/SlackIntegrationService;", "Ljetbrains/youtrack/ring/sync/service/RingService;", "()V", "key", "", "getKey", "()Ljava/lang/String;", "secret", "getSecret", "url", "kotlin.jvm.PlatformType", "uuid", "getUuid", "cleanupService", "", "remoteId", "getService", "Ljetbrains/jetpass/api/Service;", "isRegistered", "", "register", "toDto", "Ljetbrains/jetpass/rest/dto/ServiceJSON;", "update", "updateVendorData", "serviceId", "serviceSecret", "youtrack-ring-integration"})
public final class SlackIntegrationService
implements RingService {
    private final String url = ConfigurationParameter.getParameter((String)"jetbrains.youtrack.konnector.url", (String)"");

    @Override
    @NotNull
    public String getKey() {
        String string = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getKonnectorKey();
        if (string == null) {
            string = "service-is-disabled";
        }
        return string;
    }

    @Override
    @NotNull
    public String getUuid() {
        String string = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getKonnectorServiceId();
        if (string == null) {
            string = "service-is-disabled";
        }
        return string;
    }

    @Override
    @NotNull
    public String getSecret() {
        String string = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getKonnectorSecret();
        if (string == null) {
            string = "service-is-disabled";
        }
        return string;
    }

    @Override
    public boolean isRegistered() {
        return this.getService() != null;
    }

    @Override
    public void register() {
        String string = this.url;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url");
        CharSequence charSequence = string;
        if (charSequence.length() > 0) {
            jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().setKonnectorSecret(UUID.randomUUID().toString());
            jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().setKonnectorServiceId(this.getClient().createService(this.toDto(), null).getId());
            this.updateVendorData(this.getUuid(), this.getSecret());
        }
    }

    @Override
    public void update() {
        Service service = this.getService();
        String string = this.url;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url");
        CharSequence charSequence = string;
        if (charSequence.length() == 0) {
            Service service2 = service;
            this.cleanupService(service2 != null ? service2.getId() : null);
        } else if (service == null) {
            this.register();
        } else {
            this.getClient().updateService(this.getUuid(), this.toDto());
            this.updateVendorData(this.getUuid(), this.getSecret());
        }
    }

    private final ServiceJSON toDto() {
        ServiceJSON service = new ServiceJSON();
        service.setId(this.getUuid());
        service.setKey(this.getKey());
        service.setSecret(this.getSecret());
        service.setTrusted(Boolean.valueOf(true));
        service.setHomeUrl(this.url);
        service.setName(BeansKt.getCentralManager().getApplicationName() + " Slack Integration");
        service.setIconUrl(this.getYouTrackIconDataUri());
        service.setRedirectUris((Iterable)CollectionsKt.listOf((Object)UriBuilder.fromPath((String)this.url).path("ring").path("oauth").build(new Object[0]).toString()));
        return service;
    }

    private final void updateVendorData(String serviceId, String serviceSecret) {
        BaseAccountsClient client2 = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getHubClient().getAccountsClient(serviceId, serviceSecret, new String[0]);
        ServiceJSON service = new ServiceJSON();
        service.setApplicationName("YouTrack Slack Integration");
        service.setVersion(RingService.Companion.getVERSION());
        service.setVendor("JetBrains");
        service.setReleaseDate(RingService.Companion.getRELEASE_DATE());
        client2.getServiceClient().updateService(serviceId, service);
    }

    private final Service getService() {
        Filter filter = new Filter(null, 1, null);
        filter.query("key: " + this.getKey());
        return (Service)CollectionsKt.firstOrNull((List)this.getClient().getServicePage((BaseFilter)filter, null).getServices());
    }

    private final void cleanupService(String remoteId) {
        if (remoteId != null && Intrinsics.areEqual((Object)jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getKonnectorServiceId(), (Object)remoteId)) {
            ServiceClient.deleteService$default((ServiceClient)this.getClient(), (String)remoteId, null, (int)2, null);
            jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().setKonnectorServiceId(null);
            jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().setKonnectorSecret(null);
        }
    }

    public SlackIntegrationService() {
        if (jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getKonnectorKey() == null) {
            jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().setKonnectorKey(UUID.randomUUID().toString());
        }
    }

    @Override
    @NotNull
    public ServiceClient getClient() {
        return RingService.DefaultImpls.getClient(this);
    }

    @Override
    @Nullable
    public String getYouTrackIconDataUri() {
        return RingService.DefaultImpls.getYouTrackIconDataUri(this);
    }
}

