/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.sync.service;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.settings.LicenseSettings;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.pojo.api.ServiceImpl;
import jetbrains.jetpass.pojo.api.settings.LicenseSettingsImpl;
import jetbrains.jetpass.rest.dto.LicenseJSON;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.XdNotificationsConfig;
import jetbrains.youtrack.ring.client.ConnectionTestResult;
import jetbrains.youtrack.ring.sync.service.RingService;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdExtensionsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;
import webr.framework.url.UrlUtil;

@Component
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/ring/sync/service/YouTrackService;", "Ljetbrains/youtrack/ring/sync/service/RingService;", "()V", "key", "", "getKey", "()Ljava/lang/String;", "secret", "getSecret", "uuid", "getUuid", "getServiceJsonForCreate", "Ljetbrains/jetpass/rest/dto/ServiceJSON;", "getServiceJsonForUpdate", "isRegistered", "", "normalizeUrl", "url", "register", "", "update", "Companion", "youtrack-ring-integration"})
public final class YouTrackService
implements RingService {
    @NotNull
    private static final Partial<Partial.Service> REGISTER_PARTIAL;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getUuid() {
        String string = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Override
    @NotNull
    public String getSecret() {
        String string = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getSecret();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.getUuid();
    }

    @Override
    public boolean isRegistered() {
        return Intrinsics.areEqual((Object)jetbrains.youtrack.ring.client.BeansKt.getHubClientFactory().testConnection(), (Object)ConnectionTestResult.Companion.getSERVICE_NOT_REGISTERED()) ^ true;
    }

    @Override
    public void register() {
        ServiceClient client2 = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAnonymousAccountsClient().getServiceClient();
        ServiceJSON created = client2.createService(this.getServiceJsonForCreate(), (FieldPartial)REGISTER_PARTIAL);
        jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().setServiceId(created.getId());
        jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().setSecret(created.getSecret());
        LegacySupportKt.flush();
    }

    @Override
    public void update() {
        LicenseSettings hubLicenseSettings = jetbrains.youtrack.ring.client.BeansKt.getRingApi().getSettingsDAO().getLicenseSettings();
        if (BeansKt.getRingConfig().hasEmbeddedHub()) {
            Service service = hubLicenseSettings.getService();
            if (service == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)service, (String)"hubLicenseSettings.service!!");
            if (Intrinsics.areEqual((Object)service.getId(), (Object)jetbrains.youtrack.ring.impl.BeansKt.getHubServiceUuid())) {
                ServiceImpl service2 = new ServiceImpl();
                service2.setId(jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId());
                service2.setApplicationName("YouTrack");
                jetbrains.youtrack.ring.client.BeansKt.getRingApi().getServiceDAO().update(jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId(), (IdItem)service2);
                LicenseSettingsImpl youtrackLicenseSettings = new LicenseSettingsImpl();
                youtrackLicenseSettings.setService((Service)service2);
                youtrackLicenseSettings.setLicenseName(jetbrains.charisma.persistent.BeansKt.getXdApplicationMetaData().getUsername());
                youtrackLicenseSettings.setLicenseKey(jetbrains.charisma.persistent.BeansKt.getXdApplicationMetaData().getLicense());
                jetbrains.youtrack.ring.client.BeansKt.getRingApi().getSettingsDAO().update(hubLicenseSettings.getId(), (IdItem)youtrackLicenseSettings);
            }
        }
        if (BeansKt.getRingConfig().hasEmbeddedHub()) {
            UserGroupJSON allUsers = new UserGroupJSON(jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserGroupDAO().getRootUserGroup());
            Service service = (Service)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getServiceDAO().get(this.getUuid());
            if (service != null) {
                Service service3;
                Service it = service3 = service;
                this.getClient().getHeadervisiblegroupsClient(this.getUuid()).addHeaderVisibleGroup(allUsers, null);
            }
        }
        ServiceClient serviceClient = this.getClient();
        String string = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        serviceClient.updateService(string, this.getServiceJsonForUpdate());
    }

    private final ServiceJSON getServiceJsonForCreate() {
        ServiceJSON service = this.getServiceJsonForUpdate();
        service.setName(BeansKt.getCentralManager().getApplicationName());
        return service;
    }

    private final ServiceJSON getServiceJsonForUpdate() {
        ServiceJSON youtrack = new ServiceJSON();
        youtrack.setId(jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId());
        youtrack.setSecret(jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getSecret());
        String homeUrl = null;
        try {
            homeUrl = UrlUtil.getGlobalBaseUrl();
        }
        catch (Exception e) {
            Companion.getLogger().warn("Unable to compute home URL for YouTrack service, falling back to 127.0.0.1", (Throwable)e);
        }
        if (homeUrl == null) {
            homeUrl = ((XdNotificationsConfig)XdExtensionsKt.toXd((Entity)((Entity)jetbrains.charisma.persistent.BeansKt.getNotificationsConfig()))).getBaseUrl();
        }
        if (homeUrl == null) {
            youtrack.setHomeUrl("http://127.0.0.1");
        } else {
            youtrack.setHomeUrl(this.normalizeUrl(homeUrl));
        }
        youtrack.setApplicationName("YouTrack");
        youtrack.setVersion(RingService.Companion.getVERSION());
        youtrack.setVendor("JetBrains");
        youtrack.setIconUrl(this.getYouTrackIconDataUri());
        youtrack.setReleaseDate(RingService.Companion.getRELEASE_DATE());
        youtrack.setUserUriPattern("/users/:id");
        youtrack.setGroupUriPattern("");
        LicenseJSON license = new LicenseJSON();
        license.setLicenseName(jetbrains.charisma.persistent.BeansKt.getXdApplicationMetaData().getUsername());
        license.setLicenseKey(jetbrains.charisma.persistent.BeansKt.getXdApplicationMetaData().getLicense());
        youtrack.setLicenseSettings(license);
        return youtrack;
    }

    private final String normalizeUrl(String url) {
        return StringsKt.startsWith$default((String)url, (String)"http", (boolean)false, (int)2, null) ? url : "http://" + url;
    }

    static {
        Companion = new Companion(null);
        Partial partial = Partial.service((Partial.Service[])new Partial.Service[]{Partial.Service.ID, Partial.Service.SECRET});
        Intrinsics.checkExpressionValueIsNotNull((Object)partial, (String)"Partial.service(Partial.\u2026, Partial.Service.SECRET)");
        REGISTER_PARTIAL = partial;
    }

    @Override
    @NotNull
    public ServiceClient getClient() {
        return RingService.DefaultImpls.getClient(this);
    }

    @Override
    @Nullable
    public String getYouTrackIconDataUri() {
        return RingService.DefaultImpls.getYouTrackIconDataUri(this);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ljetbrains/youtrack/ring/sync/service/YouTrackService$Companion;", "Lmu/KLogging;", "()V", "REGISTER_PARTIAL", "Ljetbrains/jetpass/client/accounts/Partial;", "Ljetbrains/jetpass/client/accounts/Partial$Service;", "getREGISTER_PARTIAL", "()Ljetbrains/jetpass/client/accounts/Partial;", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final Partial<Partial.Service> getREGISTER_PARTIAL() {
            return REGISTER_PARTIAL;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

