/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicLong;
import jetbrains.youtrack.scripts.loader.ScriptSource;
import jetbrains.youtrack.scripts.loader.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptFile
implements ScriptSource {
    private static final String SEPARATOR = ".jar!";
    private static AtomicLong modificationTimestamp = new AtomicLong(0L);
    protected static Log log = LogFactory.getLog(ScriptFile.class);
    private String name;
    private URL resource;
    private int version;
    private boolean autoAttached;
    private boolean readOnly;
    private String title;

    public ScriptFile(String name, URL resource) {
        this.name = name;
        this.resource = resource;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Long getUpdated() {
        long val = modificationTimestamp.get();
        if (val == 0L) {
            val = this.getLastModified();
            modificationTimestamp.set(val);
        }
        return val;
    }

    @Override
    public InputStream getBody() {
        try {
            return (InputStream)this.resource.getContent();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isAutoAttached() {
        return this.autoAttached;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    private Long getLastModified() {
        String filePath = this.resource.getFile();
        if (filePath == null || filePath.length() == 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Resource " + this.resource + " does not represent a file"));
            }
            return null;
        }
        int separatorIndex = filePath.indexOf(SEPARATOR);
        if (separatorIndex == -1) {
            try {
                File file = new File(this.resource.toURI());
                return file.lastModified();
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Exception retrieving lastModified time for " + this.resource), (Throwable)e);
                }
                return null;
            }
        }
        try {
            File jarFile = new File(new URL(StringUtils.substring(filePath, 0, separatorIndex) + ".jar").toURI());
            return jarFile.lastModified();
        }
        catch (IOException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Exception retrieving lastModified time for " + this.resource), (Throwable)e);
            }
            return null;
        }
        catch (URISyntaxException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Exception retrieving lastModified time for " + this.resource), (Throwable)e);
            }
            return null;
        }
    }

    public ScriptFile setVersion(int version) {
        this.version = version;
        return this;
    }

    public ScriptFile setAutoAttached(boolean autoAttached) {
        this.autoAttached = autoAttached;
        return this;
    }

    public ScriptFile setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public ScriptFile setTitle(String title) {
        this.title = title;
        return this;
    }
}

