/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.loader;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.youtrack.scripts.loader.ScriptFile;
import jetbrains.youtrack.scripts.loader.ScriptSource;
import jetbrains.youtrack.scripts.loader.ScriptsLoader;

public class ScriptFilesLoader
extends ScriptsLoader {
    private List<String> myNames;
    private boolean myReadOnlyScripts;

    @Override
    protected Iterable<ScriptSource> getScripts() {
        return ListSequence.fromList(this.getNames()).select((_FunctionTypes._return_P1_E0)new ISelector<String, ScriptSource>(){

            public ScriptSource select(String name) {
                return new ScriptFile(name, ScriptFilesLoader.this.getClass().getClassLoader().getResource(name + ".js")).setVersion(ScriptFilesLoader.this.versionNumber()).setReadOnly(ScriptFilesLoader.this.getReadOnlyScripts());
            }
        });
    }

    public List<String> getNames() {
        return this.myNames;
    }

    public void setNames(List<String> value) {
        this.myNames = value;
    }

    public boolean getReadOnlyScripts() {
        return this.myReadOnlyScripts;
    }

    public void setReadOnlyScripts(boolean value) {
        this.myReadOnlyScripts = value;
    }

    public static String encodeFileName(String decodedName) {
        try {
            String encodedName = URLEncoder.encode(decodedName, "UTF-8");
            if (encodedName != null && encodedName.indexOf("*") >= 0) {
                encodedName = encodedName.replace("*", "%2A");
            }
            return encodedName;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodeFileName(String encodedName) {
        try {
            return URLDecoder.decode(encodedName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

