/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.BadRequestException;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.charisma.customfields.persistence.fields.XdField;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.runtime.templateComponent.LogicException;
import jetbrains.youtrack.agile.persistence.AgileColumnsKt;
import jetbrains.youtrack.agile.persistence.AgileStatusKt;
import jetbrains.youtrack.agile.persistence.XdAgile;
import jetbrains.youtrack.agile.persistence.XdAgileColumn;
import jetbrains.youtrack.agile.persistence.XdSprint;
import jetbrains.youtrack.agile.persistence.XdStateSortOrder;
import jetbrains.youtrack.agile.persistence.XdUserSwimlaneSettings;
import jetbrains.youtrack.agile.persistence.XdUserSwimlaneSettingsKt;
import jetbrains.youtrack.agile.persistence.swimlane.SwimlaneSettingsLogic;
import jetbrains.youtrack.agile.persistence.swimlane.XdSwimlaneSettings;
import jetbrains.youtrack.agile.rest.BeansKt;
import jetbrains.youtrack.agile.sprint.cell.CellIssuesOrderKt;
import jetbrains.youtrack.agile.sprint.logic.SprintLogic;
import jetbrains.youtrack.api.workflow.StateMachineProvider;
import jetbrains.youtrack.core.persistent.order.XdSortOrder;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.gaprest.db.util.HelpersKt;
import jetbrains.youtrack.gaprest.exception.LocalizedBadRequestException;
import jetbrains.youtrack.gaprest.exception.LocalizedForbiddenException;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdIssueKt;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u001a\u0010\f\u001a\u00020\t*\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0014\u0010\u0010\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0014\u0010\u0016\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0017\u001a\u00020\t*\u00020\r2\u0006\u0010\u0018\u001a\u00020\r\u001a\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u0015*\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u0014\u0010\u001b\u001a\u00020\u0001*\u00020\n2\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u001a\u001c\u0010\u001e\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u001f\u001a\u00020\u000f2\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u001a\u0012\u0010 \u001a\u00020\t*\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0003\u001a\"\u0010!\u001a\u00020\t*\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\n\u001a,\u0010!\u001a\u00020\t*\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\n2\b\u0010#\u001a\u0004\u0018\u00010\u0003\u001a!\u0010$\u001a\u00020\t*\u00020\r2\u0006\u0010\u001f\u001a\u00020\u000f2\b\u0010%\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010&\u001a\u001c\u0010'\u001a\u00020\t*\u00020\n2\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u0001\u001a$\u0010)\u001a\u00020\t*\u00020\r2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u00012\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u001a.\u0010+\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\"\u0010,\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006/"}, d2={"isSprintCard", "", "parent", "Ljetbrains/youtrack/persistent/XdIssue;", "filter", "Lkotlin/Function1;", "swimlaneSettingsLogic", "Ljetbrains/youtrack/agile/persistence/swimlane/SwimlaneSettingsLogic;", "addIssue", "", "Ljetbrains/youtrack/agile/persistence/XdAgileColumn;", "issue", "addIssueToRow", "Ljetbrains/youtrack/agile/persistence/XdSprint;", "rowId", "", "assertCanAddIssue", "constrainsValidationException", "Ljetbrains/exodus/database/exceptions/ConstraintsValidationException;", "Lkotlinx/dnq/XdEntity;", "message", "", "containsIssue", "copySortOrder", "that", "getMakeOrphanMessage", "Ljetbrains/youtrack/agile/persistence/XdAgile;", "isCollapsed", "user", "Ljetbrains/youtrack/persistent/XdUser;", "isSwimlaneHidden", "swimlaneId", "makeOrphan", "moveIssue", "column", "prevIssue", "moveSwimlane", "prevSwimlaneId", "(Ljetbrains/youtrack/agile/persistence/XdSprint;JLjava/lang/Long;)V", "setCollapsed", "collapsed", "setSwimlaneHidden", "hidden", "shouldSkipAsCardSubtask", "shouldSkipAsCardSubtaskForParent", "sprintLogic", "Ljetbrains/youtrack/agile/sprint/logic/SprintLogic;", "youtrack-scrumboard"})
public final class BoardUtilKt {
    public static final void moveSwimlane(@NotNull XdSprint $receiver, long swimlaneId, @Nullable Long prevSwimlaneId) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        XdSortOrder xdSortOrder = $receiver.getSwimlanesSortOrder$youtrack_scrumboard();
        Object object = $receiver.getAgile().getSwimlaneSettings();
        if (object == null || (object = object.getSortedSwimlaneIds($receiver)) == null) {
            object = CollectionsKt.emptyList();
        }
        xdSortOrder.move(swimlaneId, prevSwimlaneId, (Iterable)object, false);
    }

    public static final void addIssueToRow(@NotNull XdSprint $receiver, @NotNull XdIssue issue2, long rowId) {
        long currentRowId;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Object object = $receiver.getAgile().getSwimlaneSettings();
        long l = object != null && (object = object.getSettingsLogic()) != null ? object.getSwimlaneId(issue2, $receiver) : (currentRowId = XdSwimlaneSettings.Companion.getNO_SWIMLANE_ID());
        if (currentRowId == rowId) {
            return;
        }
        if (rowId == XdSwimlaneSettings.Companion.getNO_SWIMLANE_ID()) {
            String message = BoardUtilKt.getMakeOrphanMessage($receiver.getAgile(), issue2);
            if (message != null) {
                throw (Throwable)new BadRequestException(message);
            }
            BoardUtilKt.makeOrphan($receiver, issue2);
            return;
        }
        if (!$receiver.getAgile().getShowSwimlanes()) {
            throw (Throwable)new LocalizedBadRequestException("BoardUtil.No_Swimlanes", new Object[0]);
        }
        XdSwimlaneSettings xdSwimlaneSettings = $receiver.getAgile().getSwimlaneSettings();
        if (xdSwimlaneSettings == null) {
            Intrinsics.throwNpe();
        }
        xdSwimlaneSettings.getSettingsLogic().addIssueToSwimlane(issue2, rowId);
    }

    public static final void moveIssue(@NotNull XdSprint $receiver, @NotNull XdIssue issue2, long swimlaneId, @NotNull XdAgileColumn column2, @Nullable XdIssue prevIssue) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)((Object)column2), (String)"column");
        BoardUtilKt.moveIssue($receiver, issue2, swimlaneId, column2);
        XdStateSortOrder sortOrder = $receiver.getSortOrder(column2, swimlaneId);
        if (sortOrder == null) {
            sortOrder = (XdStateSortOrder)XdStateSortOrder.Companion.new((Function1)new Function1<XdStateSortOrder, Unit>($receiver, swimlaneId, column2){
                final /* synthetic */ XdSprint $this_moveIssue;
                final /* synthetic */ long $swimlaneId;
                final /* synthetic */ XdAgileColumn $column;

                public final void invoke(@NotNull XdStateSortOrder $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                    $receiver.setSwimlaneId(this.$swimlaneId);
                    $receiver.setState(this.$column);
                    $receiver.setSprint(this.$this_moveIssue);
                }
                {
                    this.$this_moveIssue = xdSprint;
                    this.$swimlaneId = l;
                    this.$column = xdAgileColumn;
                    super(1);
                }
            });
        }
        sortOrder.moveIssue(issue2, prevIssue);
    }

    /*
     * WARNING - void declaration
     */
    public static final void moveIssue(@NotNull XdSprint $receiver, @NotNull XdIssue issue2, long swimlaneId, @NotNull XdAgileColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)((Object)column2), (String)"column");
        if (AgileStatusKt.getInvalid($receiver.getAgile())) {
            throw (Throwable)new LogicException("Agile is invalid.");
        }
        BoardUtilKt.addIssueToRow($receiver, issue2, swimlaneId);
        if (!BoardUtilKt.containsIssue(column2, issue2)) {
            XdCustomFieldPrototype xdCustomFieldPrototype = $receiver.getAgile().getStatePrototype();
            if (xdCustomFieldPrototype == null) {
                Intrinsics.throwNpe();
            }
            Entity columnFieldEntity = xdCustomFieldPrototype.getEntity();
            AgileColumnsKt.assertCanMoveIssue(column2, issue2);
            BoardUtilKt.assertCanAddIssue(column2, issue2);
            if (CellIssuesOrderKt.getStateMachineProvider().hasStateMachine(issue2.getProject().getEntity(), columnFieldEntity)) {
                Collection<Entity> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable<XdField> iterable2 = column2.getValuesForIssueProject(issue2);
                Entity entity = columnFieldEntity;
                Entity entity2 = issue2.getEntity();
                StateMachineProvider stateMachineProvider = CellIssuesOrderKt.getStateMachineProvider();
                void var7_9 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    XdField xdField = (XdField)item$iv$iv;
                    collection = destination$iv$iv;
                    Entity entity3 = it.getEntity();
                    collection.add(entity3);
                }
                collection = (List)destination$iv$iv;
                stateMachineProvider.setValueWithStateMachine(entity2, entity, (Iterable)collection);
            } else {
                BoardUtilKt.addIssue(column2, issue2);
            }
        }
    }

    private static final void assertCanAddIssue(@NotNull XdAgileColumn $receiver, XdIssue issue2) {
        XdCustomFieldPrototype xdCustomFieldPrototype = $receiver.getAgile().getStatePrototype();
        if (xdCustomFieldPrototype == null) {
            Intrinsics.throwNpe();
        }
        XdCustomFieldPrototype stateField = xdCustomFieldPrototype;
        XdProjectCustomField xdProjectCustomField = stateField.getProjectCustomField(issue2.getProject());
        if (xdProjectCustomField == null) {
            throw (Throwable)new LocalizedForbiddenException("BoardUtil.No_column_field_in_project", new Object[0]);
        }
        XdProjectCustomField projectField = xdProjectCustomField;
        if (!XdProjectCustomField.isAccessibleInIssue$default((XdProjectCustomField)projectField, (Operation)Operation.UPDATE, (XdIssue)issue2, null, (int)4, null)) {
            throw (Throwable)new LocalizedForbiddenException("BoardUtil.Cant_edit_column", new Object[]{issue2.getIdReadable()});
        }
    }

    private static final boolean containsIssue(@NotNull XdAgileColumn $receiver, XdIssue issue2) {
        Iterable<XdField> iterable2 = $receiver.getValuesForIssueProject(issue2);
        XdCustomFieldPrototype xdCustomFieldPrototype = $receiver.getAgile().getStatePrototype();
        if (xdCustomFieldPrototype == null) {
            Intrinsics.throwNpe();
        }
        return CollectionsKt.contains(iterable2, (Object)xdCustomFieldPrototype.getValue(issue2));
    }

    public static final void addIssue(@NotNull XdAgileColumn $receiver, @NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        XdField value2 = (XdField)CollectionsKt.firstOrNull($receiver.getValuesForIssueProject(issue2));
        XdCustomFieldPrototype xdCustomFieldPrototype = $receiver.getAgile().getStatePrototype();
        if (xdCustomFieldPrototype == null) {
            Intrinsics.throwNpe();
        }
        xdCustomFieldPrototype.setValue(issue2, (Object)value2);
    }

    public static final void setCollapsed(@NotNull XdAgileColumn $receiver, @NotNull XdUser user, boolean collapsed2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        BeansKt.getAgileProfileService().getProfile(user).setCollapsedColumn($receiver, collapsed2);
    }

    public static /* synthetic */ void setCollapsed$default(XdAgileColumn xdAgileColumn, XdUser xdUser, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            xdUser = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        }
        BoardUtilKt.setCollapsed(xdAgileColumn, xdUser, bl);
    }

    public static final boolean isCollapsed(@NotNull XdAgileColumn $receiver, @NotNull XdUser user) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        return XdQueryKt.contains(BeansKt.getAgileProfileService().getProfile(user).getCollapsedColumns(), (XdEntity)$receiver);
    }

    public static /* synthetic */ boolean isCollapsed$default(XdAgileColumn xdAgileColumn, XdUser xdUser, int n, Object object) {
        if ((n & 1) != 0) {
            xdUser = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        }
        return BoardUtilKt.isCollapsed(xdAgileColumn, xdUser);
    }

    public static final void makeOrphan(@NotNull XdSprint $receiver, @NotNull XdIssue issue2) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            if (!$receiver.getAgile().getShowSwimlanes()) {
                return;
            }
            Object object = $receiver.getAgile().getSwimlaneSettings();
            if (object == null || (object = object.getSettingsLogic()) == null) break block1;
            object.makeOrphan($receiver, issue2);
        }
    }

    @Nullable
    public static final String getMakeOrphanMessage(@NotNull XdAgile $receiver, @NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        if (!$receiver.getShowSwimlanes()) {
            return null;
        }
        Object object = $receiver.getSwimlaneSettings();
        return object != null && (object = object.getSettingsLogic()) != null ? object.getMakeOrphanMessage(issue2) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSwimlaneHidden(@NotNull XdSprint $receiver, long swimlaneId, @NotNull XdUser user) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        XdUserSwimlaneSettings xdUserSwimlaneSettings = XdUserSwimlaneSettingsKt.findSwimlaneSettings($receiver, user);
        if (xdUserSwimlaneSettings == null) return false;
        XdUserSwimlaneSettings settings2 = xdUserSwimlaneSettings;
        if (swimlaneId == XdSwimlaneSettings.Companion.getNO_SWIMLANE_ID()) {
            if (!settings2.getOrphansCollapsed()) return false;
            XdSwimlaneSettings xdSwimlaneSettings = $receiver.getAgile().getSwimlaneSettings();
            if (xdSwimlaneSettings == null) return false;
            boolean bl = xdSwimlaneSettings.getEnabled();
            if (!bl) return false;
            return true;
        }
        boolean bl = settings2.isSwimlaneHidden(swimlaneId);
        return bl;
    }

    public static /* synthetic */ boolean isSwimlaneHidden$default(XdSprint xdSprint, long l, XdUser xdUser, int n, Object object) {
        if ((n & 2) != 0) {
            xdUser = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        }
        return BoardUtilKt.isSwimlaneHidden(xdSprint, l, xdUser);
    }

    public static final void setSwimlaneHidden(@NotNull XdSprint $receiver, long swimlaneId, boolean hidden, @NotNull XdUser user) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        XdUserSwimlaneSettings settings2 = XdUserSwimlaneSettingsKt.findOrNewSwimlaneSettings($receiver, user);
        if (swimlaneId == XdSwimlaneSettings.Companion.getNO_SWIMLANE_ID()) {
            settings2.setOrphansCollapsed(hidden);
        } else {
            settings2.setSwimlaneHidden(swimlaneId, hidden);
        }
    }

    public static /* synthetic */ void setSwimlaneHidden$default(XdSprint xdSprint, long l, boolean bl, XdUser xdUser, int n, Object object) {
        if ((n & 4) != 0) {
            xdUser = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        }
        BoardUtilKt.setSwimlaneHidden(xdSprint, l, bl, xdUser);
    }

    /*
     * WARNING - void declaration
     */
    public static final void copySortOrder(@NotNull XdSprint $receiver, @NotNull XdSprint that) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)((Object)that), (String)"that");
        $receiver.getSwimlanesSortOrder$youtrack_scrumboard().copyOrderFrom(that.getSwimlanesSortOrder$youtrack_scrumboard());
        Iterable $receiver$iv = HelpersKt.asIterable((XdQuery)((XdQuery)$receiver.getAgile().getColumnSettings()));
        Iterable iterable2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            XdAgileColumn it = (XdAgileColumn)((Object)element$iv$iv);
            if (!(!it.isResolved())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unresolvedColumns = (List)destination$iv$iv;
        $receiver$iv = HelpersKt.asIterable((XdQuery)((XdQuery)$receiver.getSortOrders()));
        for (Object element$iv : $receiver$iv) {
            XdStateSortOrder it = (XdStateSortOrder)((Object)element$iv);
            if (!unresolvedColumns.contains((Object)it.getState())) continue;
            it.cloneTo(that);
        }
    }

    public static final boolean shouldSkipAsCardSubtask(@NotNull XdSprint $receiver, @NotNull XdIssue issue2, @NotNull Function1<? super XdIssue, Boolean> filter2, @NotNull SwimlaneSettingsLogic swimlaneSettingsLogic) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull(filter2, (String)"filter");
        Intrinsics.checkParameterIsNotNull((Object)swimlaneSettingsLogic, (String)"swimlaneSettingsLogic");
        if (!$receiver.getAgile().getHideSubtasksOfCards()) {
            return false;
        }
        XdIssue parent2 = XdIssueKt.getParent((XdIssue)issue2);
        return BoardUtilKt.isSprintCard(parent2, filter2, swimlaneSettingsLogic);
    }

    public static final boolean shouldSkipAsCardSubtaskForParent(@NotNull XdSprint $receiver, @NotNull XdIssue parent2, @NotNull SprintLogic sprintLogic, @NotNull SwimlaneSettingsLogic swimlaneSettingsLogic) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)sprintLogic, (String)"sprintLogic");
        Intrinsics.checkParameterIsNotNull((Object)swimlaneSettingsLogic, (String)"swimlaneSettingsLogic");
        if (!$receiver.getAgile().getHideSubtasksOfCards()) {
            return false;
        }
        return BoardUtilKt.isSprintCard(parent2, (Function1<? super XdIssue, Boolean>)((Function1)new Function1<XdIssue, Boolean>($receiver, sprintLogic){
            final /* synthetic */ XdSprint $this_shouldSkipAsCardSubtaskForParent;
            final /* synthetic */ SprintLogic $sprintLogic;

            public final boolean invoke(@NotNull XdIssue it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return SprintLogic.DefaultImpls.matchesIssue$default(this.$sprintLogic, this.$this_shouldSkipAsCardSubtaskForParent, it, null, 4, null);
            }
            {
                this.$this_shouldSkipAsCardSubtaskForParent = xdSprint;
                this.$sprintLogic = sprintLogic;
                super(1);
            }
        }), swimlaneSettingsLogic);
    }

    @NotNull
    public static final ConstraintsValidationException constrainsValidationException(@NotNull XdEntity $receiver, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        return new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(message, $receiver.getEntity()));
    }

    private static final boolean isSprintCard(XdIssue parent2, Function1<? super XdIssue, Boolean> filter2, SwimlaneSettingsLogic swimlaneSettingsLogic) {
        return parent2 != null && (Boolean)filter2.invoke((Object)parent2) != false && !swimlaneSettingsLogic.isSwimlane(parent2);
    }
}

