/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.sprint.cell;

import javax.ws.rs.BadRequestException;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.fields.XdField;
import jetbrains.charisma.main.CollectionUtilKt;
import jetbrains.charisma.persistent.Issue;
import jetbrains.charisma.persistent.Project;
import jetbrains.charisma.persistent.sortOrder.EntityInDatabaseOrder;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.agile.Localization;
import jetbrains.youtrack.agile.persistence.XdAgile;
import jetbrains.youtrack.agile.persistence.XdAgileColumn;
import jetbrains.youtrack.agile.persistence.XdSprint;
import jetbrains.youtrack.agile.persistence.XdStateSortOrder;
import jetbrains.youtrack.agile.settings.AgileColumn;
import jetbrains.youtrack.agile.sprint.BoardColumn;
import jetbrains.youtrack.agile.sprint.cell.BoardCell;
import jetbrains.youtrack.agile.sprint.cell.CellIssuesOrderKt;
import jetbrains.youtrack.agile.sprint.cell.IBoardCellIssues;
import jetbrains.youtrack.agile.sprint.cell.LazyLoadBoardCellIssues;
import jetbrains.youtrack.agile.sprint.row.BoardRow;
import jetbrains.youtrack.api.workflow.StateMachineProvider;
import jetbrains.youtrack.gaprest.db.DatabaseEntity;
import jetbrains.youtrack.gaprest.db.util.HelpersKt;
import jetbrains.youtrack.gaprest.exception.LocalizedBadRequestException;
import jetbrains.youtrack.persistent.XdIssue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001b\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0018\u001a\u00020\u00192\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0014J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002H\u0014J\b\u0010\u001d\u001a\u00020\u0019H\u0014J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u001f\u001a\u00020\u0003H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Ljetbrains/youtrack/agile/sprint/cell/CellIssuesOrder;", "Ljetbrains/charisma/persistent/sortOrder/EntityInDatabaseOrder;", "Ljetbrains/charisma/persistent/Issue;", "Ljetbrains/youtrack/persistent/XdIssue;", "cell", "Ljetbrains/youtrack/agile/sprint/cell/BoardCell;", "sortedElementsCount", "", "(Ljetbrains/youtrack/agile/sprint/cell/BoardCell;I)V", "key", "Lkotlinx/dnq/XdEntity;", "getKey", "()Lkotlinx/dnq/XdEntity;", "leading", "getLeading", "()Ljetbrains/charisma/persistent/Issue;", "moveCommand", "", "getMoveCommand", "()Ljava/lang/String;", "moved", "getMoved", "getSortedElementsCount", "()I", "doMove", "", "findLeading", "entity", "findMoved", "resetOrder", "unwrapLeading", "unwrapMoved", "youtrack-scrumboard"})
public class CellIssuesOrder
extends EntityInDatabaseOrder<Issue, XdIssue> {
    private final BoardCell cell;
    private final int sortedElementsCount;

    @Nullable
    protected XdEntity getKey() {
        BoardCell boardCell = this.cell;
        return boardCell != null ? boardCell.getSprint() : null;
    }

    @Nullable
    public Issue getMoved() {
        return (Issue)super.getMoved();
    }

    @Nullable
    public Issue getLeading() {
        return (Issue)super.getLeading();
    }

    @Nullable
    public String getMoveCommand() {
        Iterable<XdField> fieldValues2;
        BoardCell boardCell = this.cell;
        if (boardCell == null) {
            Intrinsics.throwNpe();
        }
        XdAgile agile2 = boardCell.getSprint().getAgile();
        XdCustomFieldPrototype xdCustomFieldPrototype = agile2.getStatePrototype();
        if (xdCustomFieldPrototype == null) {
            throw (Throwable)new BadRequestException((String)Localization.INSTANCE.getNoColumnField().invoke());
        }
        XdCustomFieldPrototype customField = xdCustomFieldPrototype;
        BoardColumn boardColumn = this.cell.getColumn();
        if (boardColumn == null) {
            Intrinsics.throwNpe();
        }
        AgileColumn agileColumn = boardColumn.getAgileColumn();
        if (agileColumn == null) {
            Intrinsics.throwNpe();
        }
        AgileColumn column2 = agileColumn;
        XdAgileColumn xdAgileColumn = column2.getXdEntity();
        Issue issue2 = this.getMoved();
        if (issue2 == null) {
            Intrinsics.throwNpe();
        }
        if (CollectionUtilKt.isEmpty(fieldValues2 = xdAgileColumn.getValuesForIssueProject(issue2.getXdEntity()))) {
            throw (Throwable)new LocalizedBadRequestException("CellIssuesOrder.cant_set_value_to_this_issue", new Object[0]);
        }
        StateMachineProvider stateMachineProvider = CellIssuesOrderKt.getStateMachineProvider();
        Issue issue3 = this.getMoved();
        if (issue3 == null) {
            Intrinsics.throwNpe();
        }
        Project project2 = issue3.getProject();
        if (project2 == null) {
            Intrinsics.throwNpe();
        }
        if (stateMachineProvider.hasStateMachine((Entity)project2.getEntity(), customField.getEntity())) {
            XdCustomFieldPrototype xdCustomFieldPrototype2 = (XdCustomFieldPrototype)XdExtensionsKt.toXd((Entity)customField.getEntity());
            Issue issue4 = this.getMoved();
            if (issue4 == null) {
                Intrinsics.throwNpe();
            }
            if (CollectionsKt.contains(fieldValues2, (Object)xdCustomFieldPrototype2.getValue(issue4.getXdEntity()))) {
                return "";
            }
            for (XdField fieldValue : fieldValues2) {
                String string;
                Issue issue5 = this.getMoved();
                String string2 = CellIssuesOrderKt.getStateMachineProvider().getStateMachineEventToMove((Entity)(issue5 != null ? issue5.getEntity() : null), customField.getEntity(), fieldValue.getEntity());
                if (string2 == null) continue;
                String eventName = string = string2;
                return eventName;
            }
        } else {
            return customField.getPresentation() + ' ' + ((XdField)CollectionsKt.first(fieldValues2)).getName();
        }
        throw (Throwable)new LocalizedBadRequestException("CellIssuesOrder.cant_find_workflow_event", new Object[0]);
    }

    protected void doMove(@Nullable XdIssue leading, @NotNull XdIssue moved) {
        Intrinsics.checkParameterIsNotNull((Object)moved, (String)"moved");
        BoardCell boardCell = this.cell;
        if (boardCell == null) {
            Intrinsics.throwNpe();
        }
        CellIssuesOrderKt.access$move(boardCell, leading, moved);
    }

    @Nullable
    protected Issue findLeading(@Nullable Issue entity) {
        Issue issue2;
        Issue issue3 = entity;
        if (issue3 != null && (issue3 = (Issue)HelpersKt.find$default((DatabaseEntity)((DatabaseEntity)issue3), null, (int)1, null)) != null) {
            BoardCell boardCell;
            IBoardCellIssues issues2;
            IBoardCellIssues cellIssues;
            Issue issue4;
            Issue it = issue4 = issue3;
            BoardCell boardCell2 = this.cell;
            if (boardCell2 == null) {
                Intrinsics.throwNpe();
            }
            IBoardCellIssues iBoardCellIssues = cellIssues = (issues2 = (boardCell = boardCell2).getBoardCellIssues()).getIssuesLoaded() ? issues2 : (IBoardCellIssues)new LazyLoadBoardCellIssues(boardCell);
            if (!cellIssues.contains(it)) {
                throw (Throwable)new LocalizedBadRequestException("CellIssuesOrder.there_is_no_such_issue_in_cell", new Object[0]);
            }
            issue2 = issue4;
        } else {
            issue2 = null;
        }
        return issue2;
    }

    @NotNull
    protected Issue findMoved(@NotNull Issue entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        return (Issue)HelpersKt.find$default((DatabaseEntity)((DatabaseEntity)entity), null, (int)1, null);
    }

    @Nullable
    public XdIssue unwrapLeading() {
        Issue issue2 = this.getLeading();
        return issue2 != null ? issue2.getXdEntity() : null;
    }

    @NotNull
    public XdIssue unwrapMoved() {
        Issue issue2 = this.getMoved();
        if (issue2 == null) {
            Intrinsics.throwNpe();
        }
        return issue2.getXdEntity();
    }

    protected void resetOrder() {
        block4: {
            BoardCell boardCell = this.cell;
            if (boardCell == null) {
                Intrinsics.throwNpe();
            }
            XdSprint xdSprint = boardCell.getSprint();
            BoardColumn boardColumn = this.cell.getColumn();
            if (boardColumn == null) {
                Intrinsics.throwNpe();
            }
            AgileColumn agileColumn = boardColumn.getAgileColumn();
            if (agileColumn == null) {
                Intrinsics.throwNpe();
            }
            XdAgileColumn xdAgileColumn = agileColumn.getXdEntity();
            BoardRow boardRow = this.cell.getRow();
            if (boardRow == null) {
                Intrinsics.throwNpe();
            }
            XdStateSortOrder xdStateSortOrder = xdSprint.getSortOrder(xdAgileColumn, boardRow.getEntityLocalId());
            if (xdStateSortOrder == null) break block4;
            xdStateSortOrder.resetOrder();
        }
    }

    public int getSortedElementsCount() {
        return this.sortedElementsCount;
    }

    public CellIssuesOrder(@Nullable BoardCell cell, int sortedElementsCount) {
        this.cell = cell;
        this.sortedElementsCount = sortedElementsCount;
    }

    public /* synthetic */ CellIssuesOrder(BoardCell boardCell, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            boardCell = null;
        }
        if ((n2 & 2) != 0) {
            n = -1;
        }
        this(boardCell, n);
    }

    public CellIssuesOrder() {
        this(null, 0, 3, null);
    }
}

