/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.sprint.cell;

import java.util.Collection;
import java.util.Iterator;
import jetbrains.charisma.persistent.Issue;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.youtrack.agile.persistence.BoardUtilKt;
import jetbrains.youtrack.agile.persistence.SprintIssuesUtilKt;
import jetbrains.youtrack.agile.persistence.XdSprint;
import jetbrains.youtrack.agile.persistence.swimlane.SwimlaneSettingsLogic;
import jetbrains.youtrack.agile.settings.AgileColumn;
import jetbrains.youtrack.agile.sprint.BoardColumn;
import jetbrains.youtrack.agile.sprint.cell.BoardCell;
import jetbrains.youtrack.agile.sprint.row.BoardRow;
import jetbrains.youtrack.core.legacy.LegacyStoreContainer;
import jetbrains.youtrack.gaprest.db.DatabaseEntities;
import jetbrains.youtrack.gaprest.db.DatabaseEntity;
import jetbrains.youtrack.persistent.XdIssue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0002H&J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0002H\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00020\fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Ljetbrains/youtrack/agile/sprint/cell/IBoardCellIssues;", "Ljetbrains/youtrack/gaprest/db/DatabaseEntities;", "Ljetbrains/charisma/persistent/Issue;", "cell", "Ljetbrains/youtrack/agile/sprint/cell/BoardCell;", "getCell", "()Ljetbrains/youtrack/agile/sprint/cell/BoardCell;", "entityType", "Lkotlin/reflect/KClass;", "getEntityType", "()Lkotlin/reflect/KClass;", "issuesLoaded", "", "getIssuesLoaded", "()Z", "setIssuesLoaded", "(Z)V", "queryEngine", "Ljetbrains/exodus/query/QueryEngine;", "getQueryEngine", "()Ljetbrains/exodus/query/QueryEngine;", "sprint", "Ljetbrains/youtrack/agile/persistence/XdSprint;", "getSprint", "()Ljetbrains/youtrack/agile/persistence/XdSprint;", "add", "element", "addIssue", "", "clear", "remove", "youtrack-scrumboard"})
public interface IBoardCellIssues
extends DatabaseEntities<Issue> {
    @NotNull
    public KClass<? extends Issue> getEntityType();

    @NotNull
    public QueryEngine getQueryEngine();

    @NotNull
    public BoardCell getCell();

    @NotNull
    public XdSprint getSprint();

    public boolean getIssuesLoaded();

    public void setIssuesLoaded(boolean var1);

    public void addIssue(@NotNull Issue var1);

    public boolean add(@NotNull Issue var1);

    public boolean remove(@NotNull Issue var1);

    public void clear();

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static KClass<? extends Issue> getEntityType(IBoardCellIssues $this) {
            return Reflection.getOrCreateKotlinClass(Issue.class);
        }

        @NotNull
        public static QueryEngine getQueryEngine(IBoardCellIssues $this) {
            return LegacyStoreContainer.INSTANCE.getStore().getQueryEngine();
        }

        @NotNull
        public static XdSprint getSprint(IBoardCellIssues $this) {
            return $this.getCell().getSprint();
        }

        public static boolean add(IBoardCellIssues $this, @NotNull Issue element2) {
            SwimlaneSettingsLogic swimlaneSettingsLogic;
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            XdIssue issue2 = element2.getXdEntity();
            if (!SprintIssuesUtilKt.containsIssue($this.getSprint(), issue2)) {
                $this.getSprint().getAgile().assertCanChangeIssueSprint(issue2);
                SprintIssuesUtilKt.addIssue($this.getSprint(), issue2);
            }
            if (((Boolean)(swimlaneSettingsLogic = $this.getSprint().getAgile().getSwimlaneSettingsLogic()).getSwimlaneFilter().invoke((Object)issue2)).booleanValue()) {
                swimlaneSettingsLogic.makeTask(issue2);
            }
            XdSprint xdSprint = $this.getSprint();
            BoardRow boardRow = $this.getCell().getRow();
            if (boardRow == null) {
                Intrinsics.throwNpe();
            }
            long l = boardRow.getEntityLocalId();
            BoardColumn boardColumn = $this.getCell().getColumn();
            if (boardColumn == null) {
                Intrinsics.throwNpe();
            }
            AgileColumn agileColumn = boardColumn.getAgileColumn();
            if (agileColumn == null) {
                Intrinsics.throwNpe();
            }
            BoardUtilKt.moveIssue(xdSprint, issue2, l, agileColumn.getXdEntity());
            return true;
        }

        public static boolean remove(IBoardCellIssues $this, @NotNull Issue element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            XdIssue issue2 = element2.getXdEntity();
            $this.getSprint().getAgile().assertCanChangeIssueSprint(issue2);
            SprintIssuesUtilKt.removeIssue($this.getSprint(), issue2);
            return true;
        }

        public static void clear(IBoardCellIssues $this) {
            Iterable $receiver$iv = $this.getIterable();
            for (Object element$iv : $receiver$iv) {
                Entity it = (Entity)element$iv;
                SprintIssuesUtilKt.removeIssue($this.getSprint(), (XdIssue)XdExtensionsKt.toXd((Entity)it));
            }
        }

        public static int getSize(IBoardCellIssues $this) {
            return DatabaseEntities.DefaultImpls.getSize((DatabaseEntities)$this);
        }

        public static boolean addAll(IBoardCellIssues $this, @NotNull Collection<? extends Issue> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            return DatabaseEntities.DefaultImpls.addAll((DatabaseEntities)$this, elements);
        }

        public static boolean contains(IBoardCellIssues $this, @NotNull Issue element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            return DatabaseEntities.DefaultImpls.contains((DatabaseEntities)$this, (DatabaseEntity)((DatabaseEntity)element2));
        }

        public static boolean containsAll(IBoardCellIssues $this, @NotNull Collection<? extends Issue> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            return DatabaseEntities.DefaultImpls.containsAll((DatabaseEntities)$this, elements);
        }

        public static boolean isEmpty(IBoardCellIssues $this) {
            return DatabaseEntities.DefaultImpls.isEmpty((DatabaseEntities)$this);
        }

        @NotNull
        public static Iterator<Issue> iterator(IBoardCellIssues $this) {
            return DatabaseEntities.DefaultImpls.iterator((DatabaseEntities)$this);
        }

        public static boolean removeAll(IBoardCellIssues $this, @NotNull Collection<? extends Issue> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            return DatabaseEntities.DefaultImpls.removeAll((DatabaseEntities)$this, elements);
        }

        public static boolean retainAll(IBoardCellIssues $this, @NotNull Collection<? extends Issue> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            return DatabaseEntities.DefaultImpls.retainAll((DatabaseEntities)$this, elements);
        }

        @NotNull
        public static Entity unwrapSource(IBoardCellIssues $this, @NotNull DatabaseEntity source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            return DatabaseEntities.DefaultImpls.unwrapSource((DatabaseEntities)$this, (DatabaseEntity)source);
        }

        @NotNull
        public static Entity unwrapTarget(IBoardCellIssues $this, @NotNull DatabaseEntity target) {
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            return DatabaseEntities.DefaultImpls.unwrapTarget((DatabaseEntities)$this, (DatabaseEntity)target);
        }

        @NotNull
        public static Issue wrapTarget(IBoardCellIssues $this, @NotNull KClass<? extends Issue> type, @NotNull Entity entity) {
            Intrinsics.checkParameterIsNotNull(type, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
            return (Issue)DatabaseEntities.DefaultImpls.wrapTarget((DatabaseEntities)$this, type, (Entity)entity);
        }
    }
}

