/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.charisma.main.CollectionUtilKt;
import jetbrains.charisma.smartui.parser.search.HeavyRequestException;
import jetbrains.charisma.smartui.parser.search.IParseResult;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.search.parser.ASTUtilExtKt;
import jetbrains.youtrack.search.parser.ComplexityAnalyzerKt;
import jetbrains.youtrack.search.parser.ErrorAnalyzerKt;
import jetbrains.youtrack.search.parser.HeavySearchRequestExecutorFactory;
import jetbrains.youtrack.search.parser.IssuesSearchRequestExecutor;
import jetbrains.youtrack.search.parser.MatchesSearchRequestExecutor;
import jetbrains.youtrack.search.parser.ParseErrorImpl;
import jetbrains.youtrack.search.parser.SearchRequestExecutor;
import jetbrains.youtrack.search.parser.SearchRequestNode;
import jetbrains.youtrack.search.parser.TextSearchAnalyzer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J0\u0010\u0014\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0010\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0011H\u0016J\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\u001fH\u0016J \u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Ljetbrains/youtrack/search/parser/ParseResult;", "Ljetbrains/charisma/smartui/parser/search/IParseResult;", "inputQuery", "", "(Ljava/lang/String;)V", "ast", "Ljetbrains/youtrack/search/parser/SearchRequestNode;", "extractPositiveProjectsWithContext", "", "Ljetbrains/exodus/entitystore/EntityId;", "executor", "Ljetbrains/youtrack/search/parser/IssuesSearchRequestExecutor;", "context", "Ljetbrains/youtrack/api/parser/IContext;", "getAST", "getInputQuery", "getIssues", "", "Ljetbrains/exodus/entitystore/Entity;", "me", "getIssuesAndPositiveProjects", "Ljetbrains/mps/baseLanguage/tuples/runtime/Tuples$_2;", "getLooksLikeSearch", "field", "Ljetbrains/youtrack/api/parser/IField;", "getParseErrors", "Ljetbrains/youtrack/search/parser/ParseErrorImpl;", "getSavedQueries", "getSyntaxErrors", "getTextSearch", "hasAndExpression", "", "hasOrExpression", "isComplexRequest", "matchesIssue", "issue", "setAST", "", "searchRequestAST", "Companion", "youtrack-search"})
public final class ParseResult
implements IParseResult {
    private SearchRequestNode ast;
    private final String inputQuery;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getInputQuery() {
        return this.inputQuery;
    }

    @NotNull
    public Iterable<Entity> getIssues(@NotNull IContext context, @NotNull Entity me) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)me, (String)"me");
        return this.getIssues(new IssuesSearchRequestExecutor(), context, me);
    }

    @NotNull
    public Tuples._2<Iterable<Entity>, Set<EntityId>> getIssuesAndPositiveProjects(@NotNull IContext context, @NotNull Entity me) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)me, (String)"me");
        IssuesSearchRequestExecutor executor = new IssuesSearchRequestExecutor();
        Iterable<Entity> issues = this.getIssues(executor, context, me);
        Tuples._2 _22 = MultiTuple.from(issues, this.extractPositiveProjectsWithContext(executor, context));
        Intrinsics.checkExpressionValueIsNotNull((Object)_22, (String)"MultiTuple.from(issues, \u2026ntext(executor, context))");
        return _22;
    }

    private final Set<EntityId> extractPositiveProjectsWithContext(IssuesSearchRequestExecutor executor, IContext context) {
        Set result = executor.getPositiveProjectIds();
        if (context != null) {
            Set contextIds = context.getPositiveProjectIds();
            if (result.isEmpty()) {
                Set set = contextIds;
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"contextIds");
                result = set;
            } else if (!contextIds.isEmpty()) {
                result = new HashSet(result);
                ((HashSet)result).addAll(contextIds);
            }
        }
        return result;
    }

    private final Iterable<Entity> getIssues(IssuesSearchRequestExecutor executor, IContext context, Entity me) {
        Iterable iterable;
        try {
            iterable = (Iterable)executor.filter(this.getAST(), context, me);
        }
        catch (HeavyRequestException e) {
            Iterable iterable2 = QueryOperations.empty((String)"Issue");
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"QueryOperations.empty(\"Issue\")");
            iterable = iterable2;
        }
        return iterable;
    }

    public boolean matchesIssue(@NotNull Entity issue, @NotNull IContext context, @NotNull Entity me) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)me, (String)"me");
        try {
            bl = (Boolean)new MatchesSearchRequestExecutor(issue).filter(this.getAST(), context, me);
        }
        catch (HeavyRequestException e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public Iterable<String> getTextSearch(@Nullable IField field) {
        SearchRequestNode searchRequestNode = this.ast;
        if (searchRequestNode == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ast");
        }
        return TextSearchAnalyzer.Companion.getTextSearch(searchRequestNode, field);
    }

    @NotNull
    public Iterable<Entity> getLooksLikeSearch(@NotNull IField field) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        SearchRequestNode searchRequestNode = this.ast;
        if (searchRequestNode == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ast");
        }
        return TextSearchAnalyzer.Companion.getLooksLikeSearch(searchRequestNode, field);
    }

    @Nullable
    public Iterable<ParseErrorImpl> getParseErrors(@NotNull IContext context, @NotNull Entity me) {
        SearchRequestExecutor<List<String>> executor;
        List<String> result;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)me, (String)"me");
        Iterable<ParseErrorImpl> parseErrors = this.getSyntaxErrors();
        if (CollectionUtilKt.isEmpty(parseErrors) && !(result = (executor = Companion.getHeavySearchRequestExecutorFactory().createExecutor()).filter(this.getAST(), context, me)).isEmpty()) {
            ArrayList<ParseErrorImpl> errors = new ArrayList<ParseErrorImpl>();
            for (String e : result) {
                errors.add(new ParseErrorImpl(e));
            }
            return errors;
        }
        return parseErrors;
    }

    @Nullable
    public Iterable<ParseErrorImpl> getSyntaxErrors() {
        SearchRequestNode searchRequestNode = this.ast;
        if (searchRequestNode == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ast");
        }
        Sequence<ParseErrorImpl> sequence = ErrorAnalyzerKt.getParseErrors(searchRequestNode);
        return sequence != null ? SequencesKt.asIterable(sequence) : null;
    }

    public boolean isComplexRequest() {
        SearchRequestNode searchRequestNode = this.ast;
        if (searchRequestNode == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ast");
        }
        return ComplexityAnalyzerKt.isComplexRequest(searchRequestNode);
    }

    public boolean hasOrExpression() {
        SearchRequestNode searchRequestNode = this.ast;
        if (searchRequestNode == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ast");
        }
        return ASTUtilExtKt.hasOrExpression(searchRequestNode);
    }

    public boolean hasAndExpression() {
        SearchRequestNode searchRequestNode = this.ast;
        if (searchRequestNode == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ast");
        }
        return ASTUtilExtKt.hasAndExpression(searchRequestNode);
    }

    @NotNull
    public Iterable<Entity> getSavedQueries() {
        SearchRequestNode searchRequestNode = this.ast;
        if (searchRequestNode == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ast");
        }
        return ASTUtilExtKt.getSavedQueriesIterable(searchRequestNode);
    }

    @NotNull
    public SearchRequestNode getAST() {
        SearchRequestNode searchRequestNode = this.ast;
        if (searchRequestNode == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ast");
        }
        return searchRequestNode;
    }

    public final void setAST(@NotNull SearchRequestNode searchRequestAST) {
        Intrinsics.checkParameterIsNotNull((Object)searchRequestAST, (String)"searchRequestAST");
        this.ast = searchRequestAST;
    }

    public ParseResult(@NotNull String inputQuery) {
        Intrinsics.checkParameterIsNotNull((Object)inputQuery, (String)"inputQuery");
        this.inputQuery = inputQuery;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/search/parser/ParseResult$Companion;", "", "()V", "heavySearchRequestExecutorFactory", "Ljetbrains/youtrack/search/parser/HeavySearchRequestExecutorFactory;", "getHeavySearchRequestExecutorFactory", "()Ljetbrains/youtrack/search/parser/HeavySearchRequestExecutorFactory;", "youtrack-search"})
    public static final class Companion {
        @NotNull
        public final HeavySearchRequestExecutorFactory getHeavySearchRequestExecutorFactory() {
            String name$iv = "heavySearchRequestExecutorFactory";
            Object object = ServiceLocator.getBean((String)name$iv);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.search.parser.HeavySearchRequestExecutorFactory");
            }
            return (HeavySearchRequestExecutorFactory)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

