/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex;

import com.jetbrains.teamsys.dnq.database.ReadOnlyTransientSession;
import com.jetbrains.teamsys.dnq.database.TransientEntityStoreImpl;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Set;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.youtrack.textindex.HitsEntityIterableBase;
import jetbrains.youtrack.textindex.HitsEntityIterableHandleBase;
import jetbrains.youtrack.textindex.HitsEntityIterator;
import jetbrains.youtrack.textindex.TextIndexManagerBase;
import jetbrains.youtrack.textindex.TextIndexManagerImpl;
import jetbrains.youtrack.textindex.TransactionalIndexSearcherReference;
import jetbrains.youtrack.textindex.analysis.GenericAnalyzer;
import jetbrains.youtrack.textindex.api.FieldTextExtractor;
import jetbrains.youtrack.textindex.api.TextIndexEntityMetaData;
import jetbrains.youtrack.textindex.api.TextIndexMetaData;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SimilarResultsEntityIterable
extends HitsEntityIterableBase
implements HitsEntityIterator.Document2EntityIdConverter {
    @NonNls
    private static final String MIN_TERM_FREQ_PROP = "jetbrains.youtrack.textindex.similarity.minTermFreq";
    private static final int MIN_TERM_FREQ_VALUE = Integer.getInteger("jetbrains.youtrack.textindex.similarity.minTermFreq", 1);
    @NonNls
    private static final String MIN_DOC_FREQ_PROP = "jetbrains.youtrack.textindex.similarity.minDocFreq";
    private static final int MIN_DOC_FREQ_VALUE = Integer.getInteger("jetbrains.youtrack.textindex.similarity.minDocFreq", 1);
    @NonNls
    private static final String MAX_DOC_FREQ_PCT_PROP = "jetbrains.youtrack.textindex.similarity.maxDocFreqPct";
    private static final int MAX_DOC_FREQ_PCT_VALUE = Integer.getInteger("jetbrains.youtrack.textindex.similarity.maxDocFreqPct", 20);
    @NonNls
    private static final String MAX_QUERY_TERMS_PROP = "jetbrains.youtrack.textindex.similarity.maxQueryTerms";
    private static final int MAX_QUERY_TERMS_VALUE = Integer.getInteger("jetbrains.youtrack.textindex.similarity.maxQueryTerms", 100);
    @NonNls
    private static final String MIN_FIELD_LENGTH_PROP = "jetbrains.youtrack.textindex.similarity.minFieldLength";
    private static final int MIN_FIELD_LENGTH_VALUE = Integer.getInteger("jetbrains.youtrack.textindex.similarity.minFieldLength", 1);
    @NonNls
    private static final String BOOST_PHRASE_FACTOR_PROP = "jetbrains.youtrack.textindex.similarity.boostPhraseFactor";
    private static final int BOOST_PHRASE_FACTOR = Integer.getInteger("jetbrains.youtrack.textindex.similarity.boostPhraseFactor", 10);
    @NonNls
    private static final String MAX_RESULTS_PROP = "jetbrains.youtrack.textindex.similarity.maxResults";
    private static final int MAX_RESULTS = Integer.getInteger("jetbrains.youtrack.textindex.similarity.maxResults", 200);
    @NotNull
    private final PersistentEntityId id;
    @Nullable
    private final Float threshold;

    SimilarResultsEntityIterable(@NotNull TextIndexManagerImpl manager, @NotNull Entity entity, @Nullable Float threshold) {
        super(manager, entity.getId().getTypeId());
        this.id = (PersistentEntityId)entity.getId();
        this.threshold = threshold;
    }

    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new HitsEntityIterableHandleBase((PersistentEntityStore)this.getStore()){

            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                builder.append("similar-");
                builder.append(SimilarResultsEntityIterable.this.threshold);
                builder.append('-');
                SimilarResultsEntityIterable.this.id.toString(builder);
            }

            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                hash.apply("similar-");
                if (SimilarResultsEntityIterable.this.threshold != null) {
                    hash.apply(Float.toString(SimilarResultsEntityIterable.this.threshold.floatValue()));
                }
                hash.applyDelimiter();
                SimilarResultsEntityIterable.this.id.toHash(hash);
            }
        };
    }

    public boolean isSortedById() {
        return false;
    }

    public boolean canBeCached() {
        return false;
    }

    @Override
    @Nullable
    public EntityId getId(@NotNull Document doc) {
        long nextLocalId = TextIndexManagerImpl.getDocumentEntityLocalId(doc);
        return nextLocalId != this.id.getLocalId() ? new PersistentEntityId(this.entityTypeId, nextLocalId) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public EntityIterator getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        TransientEntityStore transientStore = this.textIndexManager.getTransientStore();
        TransientStoreSession session = transientStore.getThreadSession();
        if (session == null) {
            TransientEntityStoreImpl transientStoreImpl = (TransientEntityStoreImpl)transientStore;
            session = new ReadOnlyTransientSession(transientStoreImpl, txn);
            transientStoreImpl.registerStoreSession(session);
            try {
                EntityIterator entityIterator = this.doGetIterator(session.getEntity((EntityId)this.id));
                return entityIterator;
            }
            finally {
                session.abort();
            }
        }
        return this.doGetIterator(session.getEntity((EntityId)this.id));
    }

    private EntityIterator doGetIterator(Entity entity) {
        TextIndexMetaData.RemoveWikiFunction removeWikiFunction = this.textIndexManager.getMetaData().getRemoveWikiFunction();
        TextIndexEntityMetaData entityMetaData = this.textIndexManager.getEntityMetaData(entity);
        return this.optimisticGetIterator(10, () -> {
            TransactionalIndexSearcherReference ref = this.textIndexManager.getCurrentSearchReference();
            IndexSearcher indexSearcher = ref.get();
            HashSet allowedFields = new HashSet(Arrays.asList(entityMetaData.getFieldNames()));
            allowedFields.removeAll(this.textIndexManager.getSimilarityIgnoredFields(entityMetaData.getEntityType()));
            Query query = null;
            for (String fieldName : allowedFields) {
                GenericAnalyzer analyzer;
                FieldTextExtractor extractor = entityMetaData.getFieldTextExtractor(fieldName);
                if (extractor == null) {
                    throw new NullPointerException("No field text extractor for '" + fieldName + "'");
                }
                String fieldText = TextIndexManagerImpl.getTextSafe(entity, extractor);
                if (fieldText == null || fieldText.length() == 0 || (query = SimilarResultsEntityIterable.join(query, SimilarResultsEntityIterable.moreLikeThisQuery(fieldText = TextIndexManagerImpl.removeWiki(removeWikiFunction, entity, fieldText), fieldName, indexSearcher, analyzer = this.textIndexManager.getTextAnalyzer()))) == null || !extractor.isPhraseField()) continue;
                try {
                    String reversedField = TextIndexManagerBase.reverseQueryStringSafe(fieldText);
                    if (this.textIndexManager.boostWordForms()) {
                        query = SimilarResultsEntityIterable.join(query, new QueryParser("entire_doc_reversed", (Analyzer)analyzer).parse(reversedField));
                    }
                    Query phraseQuery = new QueryParser(fieldName, (Analyzer)analyzer).parse('\"' + TextIndexManagerBase.reverseQueryStringSafe(reversedField) + '\"');
                    query = SimilarResultsEntityIterable.join(query, (Query)new BoostQuery(phraseQuery, (float)BOOST_PHRASE_FACTOR));
                }
                catch (ParseException parseException) {}
            }
            if (query != null) {
                return new HitsEntityIterator(this, query, indexSearcher, this, null, false, this.threshold, MAX_RESULTS);
            }
            return EntityIteratorBase.EMPTY;
        });
    }

    private static MoreLikeThis moreLikeThis(@NotNull IndexSearcher indexSearcher, @NotNull GenericAnalyzer analyzer) {
        IndexReader indexReader = indexSearcher.getIndexReader();
        int numDocs = indexReader.numDocs();
        MoreLikeThis moreLikeThis = new MoreLikeThis(indexReader);
        moreLikeThis.setAnalyzer((Analyzer)analyzer);
        moreLikeThis.setStopWords((Set)analyzer.getStopwordSet());
        moreLikeThis.setMinTermFreq(Integer.getInteger(MIN_TERM_FREQ_PROP, MIN_TERM_FREQ_VALUE).intValue());
        moreLikeThis.setMinDocFreq(Integer.getInteger(MIN_DOC_FREQ_PROP, MIN_DOC_FREQ_VALUE).intValue());
        moreLikeThis.setMaxDocFreq(Math.max(1000, Integer.getInteger(MAX_DOC_FREQ_PCT_PROP, MAX_DOC_FREQ_PCT_VALUE) * numDocs / 100));
        moreLikeThis.setMaxQueryTerms(Integer.getInteger(MAX_QUERY_TERMS_PROP, MAX_QUERY_TERMS_VALUE).intValue());
        return moreLikeThis;
    }

    @Nullable
    private static Query moreLikeThisQuery(@NotNull String fieldText, @NotNull String fieldName, @NotNull IndexSearcher indexSearcher, @NotNull GenericAnalyzer analyzer) throws IOException {
        TokenStream tokenStream = TextIndexManagerBase.tokenStream(analyzer, fieldName, fieldText);
        int minFieldLength = Integer.getInteger(MIN_FIELD_LENGTH_PROP, MIN_FIELD_LENGTH_VALUE);
        for (int i = 0; i < minFieldLength; ++i) {
            if (tokenStream.incrementToken()) continue;
            return null;
        }
        MoreLikeThis moreLikeThis = SimilarResultsEntityIterable.moreLikeThis(indexSearcher, analyzer);
        moreLikeThis.setFieldNames(new String[]{fieldName});
        return moreLikeThis.like(fieldName, new Reader[]{new StringReader(fieldText)});
    }

    private static Query join(Query one, Query two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add(one, BooleanClause.Occur.SHOULD);
        queryBuilder.add(two, BooleanClause.Occur.SHOULD);
        return queryBuilder.build();
    }
}

