/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex;

import java.util.Set;
import jetbrains.exodus.core.dataStructures.decorators.HashSetDecorator;
import jetbrains.exodus.database.EntityChangeType;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientEntityChange;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.database.TransientStoreSessionListener;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.youtrack.textindex.TextIndexManagerBase;
import jetbrains.youtrack.textindex.api.TextIndexManager;
import jetbrains.youtrack.textindex.api.TextIndexMetaData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextIndexEntityStoreChangesListener
implements TransientStoreSessionListener {
    @NotNull
    private final TextIndexMetaData _textIndexMetaData;
    @NotNull
    private final TextIndexManager _textIndexManager;

    public TextIndexEntityStoreChangesListener(@NotNull TextIndexMetaData textIndexMetaData, @NotNull TextIndexManager textIndexManager) {
        this._textIndexMetaData = textIndexMetaData;
        this._textIndexManager = textIndexManager;
        if (textIndexManager instanceof TextIndexManagerBase) {
            ((TextIndexManagerBase)textIndexManager).start();
        }
    }

    public void flushed(@NotNull TransientStoreSession session, @Nullable Set<TransientEntityChange> changedEntities) {
        this.indexChanges(changedEntities);
    }

    public void beforeFlushBeforeConstraints(@NotNull TransientStoreSession session, @Nullable Set<TransientEntityChange> changedEntities) {
    }

    public void beforeFlushAfterConstraints(@NotNull TransientStoreSession session, @Nullable Set<TransientEntityChange> changedEntities) {
    }

    public void afterConstraintsFail(@NotNull TransientStoreSession session, @NotNull Set<DataIntegrityViolationException> exceptions) {
    }

    private void indexChanges(@Nullable Set<TransientEntityChange> changedEntities) {
        if (changedEntities != null) {
            HashSetDecorator deletedEntities = new HashSetDecorator();
            HashSetDecorator entitiesToReindex = new HashSetDecorator();
            for (TransientEntityChange change : changedEntities) {
                TransientEntity entity = change.getTransientEntity();
                String entityType = entity.getType();
                if (this._textIndexMetaData.getEntityMetaData(entityType) == null) continue;
                EntityId entityId = entity.getId();
                if (change.getChangeType() == EntityChangeType.REMOVE) {
                    deletedEntities.add(entityId);
                    continue;
                }
                entitiesToReindex.add(entityId);
            }
            for (EntityId id : entitiesToReindex) {
                if (deletedEntities.contains(id)) continue;
                this._textIndexManager.indexDocument(id, true);
            }
            for (EntityId id : deletedEntities) {
                this._textIndexManager.deleteDocument(id);
            }
        }
    }
}

