/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex.nodes;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.metadata.ModelMetaData;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.textindex.api.TextIndexManager;

public class TextSearch
extends NodeBase {
    private String query;
    private String field;

    public TextSearch(String query, String field) {
        this.query = query;
        this.field = field;
    }

    public NodeBase getClone() {
        return new TextSearch(this.query, this.field);
    }

    public Iterable<Entity> instantiate(String entityType, QueryEngine queryEngine, ModelMetaData metaData) {
        TextIndexManager index = TextSearch.getTextIndexManager();
        if (this.field == null) {
            return index.searchFor(this.query, entityType);
        }
        return index.searchFor(this.query, entityType, this.field);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        this.checkWildcard(obj);
        if (!(obj instanceof TextSearch)) {
            return false;
        }
        TextSearch textSearch = (TextSearch)((Object)obj);
        return TextSearch.eq_voflii_a0a5a2_0(this.query, textSearch.query) && TextSearch.eq_voflii_a0a5a2(this.field, textSearch.field);
    }

    public String toString(String prefix) {
        return super.toString(prefix) + "(" + this.query + "#" + this.field + ") ";
    }

    public StringBuilder getHandle(StringBuilder sb) {
        sb = super.getHandle(sb).append('(');
        if (this.query != null) {
            sb = sb.append(this.query).append('#');
        }
        if (this.field != null) {
            sb = sb.append(this.field);
        }
        return sb.append(')');
    }

    public String getSimpleName() {
        return "txt";
    }

    public static TextIndexManager getTextIndexManager() {
        return (TextIndexManager)ServiceLocator.getBean((String)"textIndexManager");
    }

    private static boolean eq_voflii_a0a5a2(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_voflii_a0a5a2_0(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

