/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import jetbrains.charisma.customfields.persistence.XdAbstractCustomFieldPrototype;
import jetbrains.charisma.plugins.GeneralUserProfile;
import jetbrains.charisma.timeTracking.TimeTrackingProvider;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.youtrack.api.commands.ICommandExecutor;
import jetbrains.youtrack.api.commands.ICommandExecutorFactory;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.parser.prefixTree.IPredicate;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.timetracking.BeansKt;
import jetbrains.youtrack.timetracking.TimeTrackingProviderImpl;
import jetbrains.youtrack.timetracking.TimeTrackingProviderImpl$createWorkTypeFieldValuePredicate$1$1$1;
import jetbrains.youtrack.timetracking.parser.BaseWorkItemField;
import jetbrains.youtrack.timetracking.parser.WorkTypeFieldValue;
import jetbrains.youtrack.timetracking.periodField.PeriodFieldType;
import jetbrains.youtrack.timetracking.periodField.parser.AddWorkItemCommandExecutor;
import jetbrains.youtrack.timetracking.periodField.parser.PeriodFieldValue;
import jetbrains.youtrack.timetracking.persistence.XdIssueWorkItem;
import jetbrains.youtrack.timetracking.persistence.XdPeriodProjectCustomField;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettings;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettingsKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.format.PeriodFormatter;
import org.springframework.stereotype.Service;

@Service(value="timeTrackingProvider")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0014\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\nH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060!H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0006H\u0016J\u0010\u0010%\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u0010\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006H\u0016J\u0010\u0010*\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u0018\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020.H\u0016J\u0012\u0010/\u001a\u00020#2\b\u00100\u001a\u0004\u0018\u000101H\u0016J\u0010\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\fH\u0016\u00a8\u00064"}, d2={"Ljetbrains/youtrack/timetracking/TimeTrackingProviderImpl;", "Ljetbrains/charisma/timeTracking/TimeTrackingProvider;", "()V", "createWorkItemCommandExecutor", "Ljetbrains/youtrack/api/commands/ICommandExecutor;", "type", "Ljetbrains/exodus/entitystore/Entity;", "date", "", "duration", "", "description", "", "createWorkTypeFieldValuePredicate", "Ljetbrains/youtrack/parser/prefixTree/IPredicate;", "context", "Ljetbrains/youtrack/api/parser/IContext;", "getDaysAWeek", "getLastWorkingDay", "Lorg/joda/time/DateTime;", "getMinutes", "period", "Lorg/joda/time/Period;", "getMinutesPerDay", "getPeriod", "minutes", "getPeriodFormatter", "Lorg/joda/time/format/PeriodFormatter;", "locale", "Ljava/util/Locale;", "getTimeTrackingSpentTime", "project", "getWorkItemsFromJira", "", "isPeriodField", "", "prototype", "isTimeTrackingEnabled", "isTimeTrackingRelated", "field", "Ljetbrains/youtrack/api/parser/IField;", "isTimeTrackingSpentTime", "isTimeTrackingWriteAccessible", "isWorkDay", "day", "zone", "Lorg/joda/time/DateTimeZone;", "isWorkItemCommandExecutorFactory", "factory", "Ljetbrains/youtrack/api/commands/ICommandExecutorFactory;", "parse", "value", "youtrack-time-tracking"})
public final class TimeTrackingProviderImpl
implements TimeTrackingProvider {
    @NotNull
    public Period getPeriod(int minutes) {
        return BeansKt.getWorkTimeSettings().getPeriod(minutes);
    }

    public int getDaysAWeek() {
        return BeansKt.getWorkTimeSettings().getDaysAWeek();
    }

    public int getMinutesPerDay() {
        return BeansKt.getWorkTimeSettings().getMinutesADay();
    }

    public boolean isWorkDay(long day, @NotNull DateTimeZone zone) {
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        return BeansKt.getWorkTimeSettings().isWorkDay(day, zone);
    }

    @NotNull
    public DateTime getLastWorkingDay() {
        DateTimeZone dateTimeZone;
        long candidate = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L);
        if (jetbrains.charisma.persistent.BeansKt.getCurrentUser().isPresent()) {
            GeneralUserProfile generalUserProfile = jetbrains.charisma.persistent.BeansKt.getCurrentUser().getGeneralProfile();
            Intrinsics.checkExpressionValueIsNotNull((Object)generalUserProfile, (String)"currentUser.generalProfile");
            dateTimeZone = generalUserProfile.getTimeZone();
        } else {
            dateTimeZone = jetbrains.charisma.persistent.BeansKt.getXdApplicationMetaData().getTimezone();
        }
        DateTimeZone timeZone = dateTimeZone;
        while (true) {
            DateTimeZone dateTimeZone2 = timeZone;
            Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeZone2, (String)"timeZone");
            if (this.isWorkDay(candidate, dateTimeZone2)) break;
            candidate -= TimeUnit.DAYS.toMillis(1L);
        }
        return new DateTime(candidate, timeZone);
    }

    @NotNull
    public Period parse(@NotNull String value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        return BeansKt.getWorkTimeSettings().parse(value2);
    }

    public int getMinutes(@NotNull Period period) {
        Intrinsics.checkParameterIsNotNull((Object)period, (String)"period");
        return BeansKt.getWorkTimeSettings().getMinutes(period);
    }

    public boolean isPeriodField(@NotNull Entity prototype) {
        Intrinsics.checkParameterIsNotNull((Object)prototype, (String)"prototype");
        return ((XdAbstractCustomFieldPrototype)XdExtensionsKt.toXd((Entity)prototype)).getType() instanceof PeriodFieldType;
    }

    @NotNull
    public PeriodFormatter getPeriodFormatter() {
        return BeansKt.getPeriodFormatterHolder().getFormatter();
    }

    @NotNull
    public PeriodFormatter getPeriodFormatter(@NotNull Locale locale) {
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        return BeansKt.getPeriodFormatterHolder().getFormatter(locale);
    }

    @NotNull
    public ICommandExecutor createWorkItemCommandExecutor(@Nullable Entity type2, long date2, int duration2, @Nullable String description) {
        Entity entity = type2;
        return new AddWorkItemCommandExecutor(entity != null ? (XdWorkItemType)XdExtensionsKt.toXd((Entity)entity) : null, date2, duration2, description);
    }

    public boolean isWorkItemCommandExecutorFactory(@Nullable ICommandExecutorFactory factory) {
        return factory instanceof PeriodFieldValue;
    }

    @NotNull
    public IPredicate<?> createWorkTypeFieldValuePredicate(@NotNull IContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return (IPredicate)new IPredicate<Object>(context){
            final /* synthetic */ IContext $context;

            public final boolean matches(Object o) {
                if (o instanceof WorkTypeFieldValue) {
                    XdWorkItemType value2 = (XdWorkItemType)((Object)((WorkTypeFieldValue)((Object)o)).getFieldValue());
                    return this.$context.allSelectedProjects((_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Boolean, Entity>(value2){
                        final /* synthetic */ XdWorkItemType $value;

                        public final boolean invoke(Entity it) {
                            return XdQueryKt.contains((XdQuery)XdQueryKt.mapDistinct((XdQuery)((XdQuery)this.$value.getUsages()), (KProperty1)((KProperty1)TimeTrackingProviderImpl$createWorkTypeFieldValuePredicate$1$1$1.INSTANCE)), (Entity)it);
                        }
                        {
                            this.$value = xdWorkItemType;
                        }
                    });
                }
                return true;
            }
            {
                this.$context = iContext;
            }
        };
    }

    public boolean isTimeTrackingEnabled(@NotNull Entity project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return XdTimeTrackingSettingsKt.getTimeTrackingSettings((XdProject)XdExtensionsKt.toXd((Entity)project2)).getEnabled();
    }

    public boolean isTimeTrackingWriteAccessible(@NotNull Entity project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser().hasPermissionInProject(Permission.UPDATE_WORK_ITEM, new XdProject[]{(XdProject)XdExtensionsKt.toXd((Entity)project2)});
    }

    public boolean isTimeTrackingSpentTime(@NotNull Entity project2, @NotNull Entity prototype) {
        XdPeriodProjectCustomField xdPeriodProjectCustomField;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)prototype, (String)"prototype");
        return this.isTimeTrackingEnabled(project2) && Intrinsics.areEqual((Object)prototype, (xdPeriodProjectCustomField = XdTimeTrackingSettingsKt.getTimeTrackingSettings((XdProject)XdExtensionsKt.toXd((Entity)project2)).getSpentTime()) != null && (xdPeriodProjectCustomField = xdPeriodProjectCustomField.getPrototype()) != null ? xdPeriodProjectCustomField.getEntity() : null);
    }

    @NotNull
    public Iterable<Entity> getWorkItemsFromJira() {
        return XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdIssueWorkItem.Companion), (Function2)getWorkItemsFromJira.1.INSTANCE).getEntityIterable();
    }

    @Nullable
    public Entity getTimeTrackingSpentTime(@NotNull Entity project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        XdTimeTrackingSettings tts = XdTimeTrackingSettingsKt.getTimeTrackingSettings((XdProject)XdExtensionsKt.toXd((Entity)project2));
        if (tts.getEnabled()) {
            XdPeriodProjectCustomField xdPeriodProjectCustomField = tts.getSpentTime();
            return xdPeriodProjectCustomField != null ? xdPeriodProjectCustomField.getEntity() : null;
        }
        return null;
    }

    public boolean isTimeTrackingRelated(@NotNull IField field) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        return field instanceof BaseWorkItemField;
    }
}

