/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking.oldrest;

import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import jetbrains.charisma.customfields.oldRest.ProjectCustomFieldRef;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.charisma.customfields.persistence.XdProjectCustomFieldKt;
import jetbrains.charisma.customfields.simple.common.BeansKt;
import jetbrains.charisma.rest.HasPermissionSecurityConstraint;
import jetbrains.charisma.smartadmin.rest.ResponseUtil;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.rpc.rest.runtime.Transformer;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.timetracking.oldrest.AdminTimeTrackingResource;
import jetbrains.youtrack.timetracking.oldrest.TimeTrackingResourcesKt;
import jetbrains.youtrack.timetracking.oldrest.pojo.TimeTrackingSettings;
import jetbrains.youtrack.timetracking.oldrest.pojo.WorkItemType;
import jetbrains.youtrack.timetracking.persistence.XdPeriodProjectCustomField;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettings;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettingsKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemType;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Transactional
@Produces(value={"application/json;charset=UTF-8", "application/xml;charset=UTF-8"})
@Component(value="old.timetracking.rest.AdminTimeTrackingResource")
@Path(value="/admin/project/{project}/timetracking")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u001c\u0010\t\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0015\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0011H\u0007\u00a8\u0006\u0017"}, d2={"Ljetbrains/youtrack/timetracking/oldrest/AdminTimeTrackingResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "addWorkType", "Ljavax/ws/rs/core/Response;", "projectEntity", "Ljetbrains/exodus/entitystore/Entity;", "type", "Ljetbrains/youtrack/timetracking/persistence/XdWorkItemType;", "deleteWorkType", "findPeriodField", "Ljetbrains/youtrack/timetracking/persistence/XdPeriodProjectCustomField;", "project", "Ljetbrains/youtrack/persistent/XdProject;", "name", "", "get", "Ljetbrains/youtrack/timetracking/oldrest/pojo/TimeTrackingSettings;", "getWorkType", "", "Ljetbrains/youtrack/timetracking/oldrest/pojo/WorkItemType;", "put", "settings", "youtrack-time-tracking"})
public final class AdminTimeTrackingResource
implements Resource {
    @GET
    @NotNull
    public final TimeTrackingSettings get(@Transformer(value="projectById") @PathParam(value="project") @NotNull Entity projectEntity) {
        Intrinsics.checkParameterIsNotNull((Object)projectEntity, (String)"projectEntity");
        HasPermissionSecurityConstraint.check((Permission)Permission.READ_WORK_ITEM, (Entity)projectEntity);
        XdProject project2 = (XdProject)XdExtensionsKt.toXd((Entity)projectEntity);
        return new TimeTrackingSettings(XdTimeTrackingSettingsKt.getTimeTrackingSettings(project2));
    }

    @PUT
    @NotNull
    public final Response put(@Transformer(value="projectById") @PathParam(value="project") @NotNull Entity projectEntity, @NotNull TimeTrackingSettings settings) {
        Boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)projectEntity, (String)"projectEntity");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        HasPermissionSecurityConstraint.check((Permission)Permission.UPDATE_PROJECT, (Entity)projectEntity);
        XdProject project2 = (XdProject)XdExtensionsKt.toXd((Entity)projectEntity);
        XdTimeTrackingSettings tts = XdTimeTrackingSettingsKt.getTimeTrackingSettings(project2);
        Boolean bl2 = settings.getEnabled();
        if (bl2 != null) {
            bl = bl2;
            boolean it = bl;
            tts.setEnabled(it);
        }
        ProjectCustomFieldRef projectCustomFieldRef = settings.getEstimation();
        if (projectCustomFieldRef != null) {
            Boolean it = bl = projectCustomFieldRef;
            String string = it.getName();
            if (string == null) {
                throw (Throwable)new BadRequestException();
            }
            tts.setEstimate(this.findPeriodField(project2, string));
        }
        ProjectCustomFieldRef projectCustomFieldRef2 = settings.getSpentTime();
        if (projectCustomFieldRef2 != null) {
            Boolean it = bl = projectCustomFieldRef2;
            String string = it.getName();
            if (string == null) {
                throw (Throwable)new BadRequestException();
            }
            tts.setSpentTime(this.findPeriodField(project2, string));
        }
        LegacySupportKt.flush();
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    @GET
    @Path(value="/worktype")
    @NotNull
    public final List<WorkItemType> getWorkType(@Transformer(value="projectById") @PathParam(value="project") @NotNull Entity projectEntity) {
        Intrinsics.checkParameterIsNotNull((Object)projectEntity, (String)"projectEntity");
        HasPermissionSecurityConstraint.check((Permission)Permission.READ_WORK_ITEM, (Entity)projectEntity);
        XdProject project2 = (XdProject)XdExtensionsKt.toXd((Entity)projectEntity);
        TimeTrackingResourcesKt.assertTimeTrackingEnabled(project2);
        XdTimeTrackingSettings settings = XdTimeTrackingSettingsKt.getTimeTrackingSettings(project2);
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)XdQueryKt.asSequence((XdQuery)((XdQuery)settings.getWorkItemTypes())), (Function1)getWorkType.1.INSTANCE));
    }

    @PUT
    @Path(value="/worktype/{type}")
    @NotNull
    public final Response addWorkType(@Transformer(value="projectById") @PathParam(value="project") @NotNull Entity projectEntity, @Transformer(value="workTypeById") @PathParam(value="type") @NotNull XdWorkItemType type2) {
        Intrinsics.checkParameterIsNotNull((Object)projectEntity, (String)"projectEntity");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type2), (String)"type");
        HasPermissionSecurityConstraint.check((Permission)Permission.UPDATE_PROJECT, (Entity)projectEntity);
        XdProject project2 = (XdProject)XdExtensionsKt.toXd((Entity)projectEntity);
        TimeTrackingResourcesKt.assertTimeTrackingEnabled(project2);
        XdTimeTrackingSettings settings = XdTimeTrackingSettingsKt.getTimeTrackingSettings(project2);
        if (!XdQueryKt.contains((XdQuery)((XdQuery)settings.getWorkItemTypes()), (XdEntity)type2)) {
            settings.getWorkItemTypes().add((XdEntity)type2);
        }
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    @DELETE
    @Path(value="/worktype/{type}")
    @NotNull
    public final Response deleteWorkType(@Transformer(value="projectById") @PathParam(value="project") @NotNull Entity projectEntity, @Transformer(value="workTypeById") @PathParam(value="type") @NotNull XdWorkItemType type2) {
        Intrinsics.checkParameterIsNotNull((Object)projectEntity, (String)"projectEntity");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type2), (String)"type");
        HasPermissionSecurityConstraint.check((Permission)Permission.UPDATE_PROJECT, (Entity)projectEntity);
        XdProject project2 = (XdProject)XdExtensionsKt.toXd((Entity)projectEntity);
        TimeTrackingResourcesKt.assertTimeTrackingEnabled(project2);
        XdTimeTrackingSettings settings = XdTimeTrackingSettingsKt.getTimeTrackingSettings(project2);
        if (XdQueryKt.contains((XdQuery)((XdQuery)settings.getWorkItemTypes()), (XdEntity)type2)) {
            settings.getWorkItemTypes().remove((XdEntity)type2);
        }
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    private final XdPeriodProjectCustomField findPeriodField(XdProject project2, String name2) {
        XdProjectCustomField spentTime = XdProjectCustomFieldKt.getProjectCustomField((XdProject)project2, (String)name2);
        ResponseUtil.assertExist((String)"Project custom field", (Object)spentTime, (String)name2, (boolean)true);
        XdProjectCustomField xdProjectCustomField = spentTime;
        if (xdProjectCustomField == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual((Object)xdProjectCustomField.getPrototype().getType(), (Object)BeansKt.getPeriodFieldType()) ^ true) {
            Throwable throwable;
            if (spentTime.isRemoved()) {
                throwable = (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(name2 + " field should have period type.", null, 2, null));
            } else {
                Entity entity = spentTime.getEntity();
                if (entity == null) {
                    throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.database.TransientEntity");
                }
                throwable = (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(name2 + " field should have period type.", (Entity)((TransientEntity)entity)));
            }
            throw throwable;
        }
        return (XdPeriodProjectCustomField)spentTime;
    }
}

