/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking.oldrest;

import java.net.URI;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import jetbrains.charisma.main.BeansKt;
import jetbrains.charisma.persistent.security.PrincipalsKt;
import jetbrains.charisma.rest.HasPermissionSecurityConstraint;
import jetbrains.charisma.smartadmin.rest.ResponseUtil;
import jetbrains.charisma.smartadmin.rest.UserRef;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.provider.exception.BadRequestException;
import jetbrains.mps.webr.rpc.rest.provider.exception.ForbiddenException;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.rpc.rest.runtime.Transformer;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.PersitenceExtensionsKt;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.timetracking.oldrest.IssueWorkItemResource;
import jetbrains.youtrack.timetracking.oldrest.TimeTrackingResourcesKt;
import jetbrains.youtrack.timetracking.oldrest.pojo.WorkItem;
import jetbrains.youtrack.timetracking.oldrest.pojo.WorkItemType;
import jetbrains.youtrack.timetracking.persistence.XdIssueWorkItem;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettingsKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Produces(value={"application/json;charset=UTF-8", "application/xml;charset=UTF-8"})
@Transactional
@Path(value="/issue/{issue}/timetracking/workitem")
@Component(value="old.timetracking.rest.IssueWorkItemResource")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u00020\u000b2\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\u000e\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000bH\u0007J$\u0010\u0012\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0007\u00a8\u0006\u0013"}, d2={"Ljetbrains/youtrack/timetracking/oldrest/IssueWorkItemResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "deleteWorkItem", "Ljavax/ws/rs/core/Response;", "issueEntity", "Ljetbrains/exodus/entitystore/Entity;", "workItem", "Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem;", "get", "", "Ljetbrains/youtrack/timetracking/oldrest/pojo/WorkItem;", "getType", "Ljetbrains/youtrack/timetracking/persistence/XdWorkItemType;", "newWorkItem", "project", "Ljetbrains/youtrack/persistent/XdProject;", "getWorkItem", "updateWorkItem", "youtrack-time-tracking"})
public final class IssueWorkItemResource
implements Resource {
    @GET
    @NotNull
    public final List<WorkItem> get(@Transformer(value="issueById") @PathParam(value="issue") @NotNull Entity issueEntity) {
        Intrinsics.checkParameterIsNotNull((Object)issueEntity, (String)"issueEntity");
        XdIssue issue2 = (XdIssue)XdExtensionsKt.toXd((Entity)issueEntity);
        TimeTrackingResourcesKt.assertTimeTrackingEnabled(issue2.getProject());
        HasPermissionSecurityConstraint.check((Permission)Permission.READ_WORK_ITEM, (Entity)issue2.getProject().getEntity());
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)XdQueryKt.asSequence(XdWorkItemKt.getWorkItems(issue2)), (Function1)get.1.INSTANCE), (Function1)get.2.INSTANCE));
    }

    @GET
    @Path(value="/{workItem}")
    @NotNull
    public final WorkItem getWorkItem(@Transformer(value="issueById") @PathParam(value="issue") @NotNull Entity issueEntity, @Transformer(value="workItemById") @PathParam(value="workItem") @NotNull XdIssueWorkItem workItem2) {
        Intrinsics.checkParameterIsNotNull((Object)issueEntity, (String)"issueEntity");
        Intrinsics.checkParameterIsNotNull((Object)((Object)workItem2), (String)"workItem");
        XdIssue issue2 = (XdIssue)XdExtensionsKt.toXd((Entity)issueEntity);
        TimeTrackingResourcesKt.assertTimeTrackingEnabled(issue2.getProject());
        HasPermissionSecurityConstraint.check((Permission)Permission.READ_WORK_ITEM, (Entity)issue2.getProject().getEntity());
        return new WorkItem(workItem2);
    }

    @PUT
    @Path(value="/{workItem}")
    @NotNull
    public final Response updateWorkItem(@Transformer(value="issueById") @PathParam(value="issue") @NotNull Entity issueEntity, @Transformer(value="workItemById") @PathParam(value="workItem") @NotNull XdIssueWorkItem workItem2, @NotNull WorkItem newWorkItem) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)issueEntity, (String)"issueEntity");
        Intrinsics.checkParameterIsNotNull((Object)((Object)workItem2), (String)"workItem");
        Intrinsics.checkParameterIsNotNull((Object)newWorkItem, (String)"newWorkItem");
        XdIssue issue2 = (XdIssue)XdExtensionsKt.toXd((Entity)issueEntity);
        TimeTrackingResourcesKt.assertTimeTrackingEnabled(issue2.getProject());
        TimeTrackingResourcesKt.assertUpdatable(workItem2);
        Long l = newWorkItem.getDate();
        if (l != null) {
            object = l;
            long it = ((Number)object).longValue();
            workItem2.setDate(it);
        }
        Integer n = newWorkItem.getDuration();
        if (n != null) {
            object = n;
            int it = ((Number)object).intValue();
            workItem2.setDuration(it);
        }
        String string = newWorkItem.getDescription();
        if (string != null) {
            Object it = object = string;
            workItem2.setDescription((String)it);
        }
        WorkItemType workItemType = newWorkItem.getWorktype();
        if (workItemType != null) {
            Object it = object = workItemType;
            workItem2.setType(this.getType(newWorkItem, issue2.getProject()));
        }
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @POST
    @NotNull
    public final Response newWorkItem(@Transformer(value="issueById") @PathParam(value="issue") @NotNull Entity issueEntity, @NotNull WorkItem workItem2) {
        void author;
        Intrinsics.checkParameterIsNotNull((Object)issueEntity, (String)"issueEntity");
        Intrinsics.checkParameterIsNotNull((Object)workItem2, (String)"workItem");
        XdIssue issue2 = (XdIssue)XdExtensionsKt.toXd((Entity)issueEntity);
        TimeTrackingResourcesKt.assertTimeTrackingEnabled(issue2.getProject());
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        UserRef userRef = workItem2.getAuthor();
        if (userRef != null) {
            String authorLogin;
            boolean canCreateNotOwn;
            UserRef userRef2;
            UserRef it = userRef2 = userRef;
            boolean bl = canCreateNotOwn = PrincipalsKt.hasPermissionInProject((Entity)((Entity)jetbrains.charisma.persistent.BeansKt.getLoggedInUser()), (Permission)Permission.UPDATE_PROJECT, (Entity)issue2.getProject().getEntity()) || PrincipalsKt.hasPermissionInProject((Entity)((Entity)jetbrains.charisma.persistent.BeansKt.getLoggedInUser()), (Permission)Permission.CREATE_NOT_OWN_WORK_ITEM, (Entity)issue2.getProject().getEntity());
            if (!canCreateNotOwn) {
                throw (Throwable)new ForbiddenException("You can't set work item author as you are not project admin.");
            }
            String string = authorLogin = it.getLogin();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"authorLogin");
            XdUser xdUser = XdUser.Companion.findUser(string);
            if (xdUser == null) {
                throw (Throwable)new BadRequestException("There is no user with login " + authorLogin);
            }
            author.element = xdUser;
        }
        Long l = workItem2.getDate();
        if (l == null) {
            throw (Throwable)new BadRequestException("Work item date is required");
        }
        long date2 = l;
        XdUser user$iv = (XdUser)author.element;
        Entity user$iv$iv = user$iv.getEntity();
        PrincipalManager _principalManager$iv$iv = BeansKt.getPrincipalManager();
        try {
            _principalManager$iv$iv.setTemporaryServerPrincipal((Object)user$iv$iv);
            XdIssueWorkItem newWorkItem = XdIssueWorkItem.Companion.new(issue2, (XdUser)author.element, date2, (Function1<? super XdIssueWorkItem, Unit>)((Function1)new Function1<XdIssueWorkItem, Unit>(this, issue2, (Ref.ObjectRef)author, date2, workItem2){
                final /* synthetic */ IssueWorkItemResource this$0;
                final /* synthetic */ XdIssue $issue$inlined;
                final /* synthetic */ Ref.ObjectRef $author$inlined;
                final /* synthetic */ long $date$inlined;
                final /* synthetic */ WorkItem $workItem$inlined;
                {
                    this.this$0 = issueWorkItemResource;
                    this.$issue$inlined = xdIssue;
                    this.$author$inlined = objectRef;
                    this.$date$inlined = l;
                    this.$workItem$inlined = workItem2;
                    super(1);
                }

                public final void invoke(@NotNull XdIssueWorkItem $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                    Integer n = this.$workItem$inlined.getDuration();
                    if (n == null) {
                        throw (Throwable)new BadRequestException("Work item duration is required");
                    }
                    $receiver.setDuration(n);
                    $receiver.setDescription(this.$workItem$inlined.getDescription());
                    $receiver.setType(IssueWorkItemResource.access$getType(this.this$0, this.$workItem$inlined, this.$issue$inlined.getProject()));
                }
            }));
            LegacySupportKt.flush();
            Response response = Response.created((URI)TimeTrackingResourcesKt.getOldRestURL(newWorkItem)).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.created(newWorkItem.oldRestURL).build()");
            Response response2 = response;
            return response2;
        }
        finally {
            _principalManager$iv$iv.unsetTemporaryServerPrincipal();
        }
    }

    @DELETE
    @Path(value="/{workItem}")
    @NotNull
    public final Response deleteWorkItem(@Transformer(value="issueById") @PathParam(value="issue") @NotNull Entity issueEntity, @Transformer(value="workItemById") @PathParam(value="workItem") @NotNull XdIssueWorkItem workItem2) {
        Intrinsics.checkParameterIsNotNull((Object)issueEntity, (String)"issueEntity");
        Intrinsics.checkParameterIsNotNull((Object)((Object)workItem2), (String)"workItem");
        XdIssue issue2 = (XdIssue)XdExtensionsKt.toXd((Entity)issueEntity);
        TimeTrackingResourcesKt.assertTimeTrackingEnabled(issue2.getProject());
        TimeTrackingResourcesKt.assertUpdatable(workItem2);
        Response response = ResponseUtil.deleted((Entity)workItem2.getEntity());
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.deleted(workItem.entity)");
        return response;
    }

    private final XdWorkItemType getType(WorkItem newWorkItem, XdProject project2) throws BadRequestException {
        XdWorkItemType type2 = null;
        WorkItemType workItemType = newWorkItem.getWorktype();
        if (workItemType == null) {
            return null;
        }
        WorkItemType worktype = workItemType;
        if (worktype.getId() != null) {
            XdEntityType xdEntityType = (XdEntityType)XdWorkItemType.Companion;
            String string = worktype.getId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if ((type2 = (XdWorkItemType)PersitenceExtensionsKt.tryFindById((XdEntityType)xdEntityType, (String)string)) == null) {
                throw (Throwable)new BadRequestException("Unknown worktype id");
            }
        } else if (worktype.getName() != null && (type2 = (XdWorkItemType)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdWorkItemType.Companion), (Function2)((Function2)new Function2<FilteringContext, XdWorkItemType, Unit>(worktype){
            final /* synthetic */ WorkItemType $worktype;

            public final void invoke(@NotNull FilteringContext $receiver, @NotNull XdWorkItemType it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                $receiver.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$worktype.getName()));
            }
            {
                this.$worktype = workItemType;
                super(2);
            }
        })))) == null) {
            throw (Throwable)new BadRequestException("Unknown worktype name");
        }
        if (type2 != null && !XdQueryKt.contains((XdQuery)((XdQuery)XdTimeTrackingSettingsKt.getTimeTrackingSettings(project2).getWorkItemTypes()), (XdEntity)type2)) {
            throw (Throwable)new BadRequestException("Worktype [" + type2.getName() + "] is not attached to project.");
        }
        return type2;
    }

    @Nullable
    public static final /* synthetic */ XdWorkItemType access$getType(IssueWorkItemResource $this, @NotNull WorkItem newWorkItem, @NotNull XdProject project2) {
        return $this.getType(newWorkItem, project2);
    }
}

