/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking.persistence;

import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.simple.common.persistence.XdSimpleProjectCustomField;
import jetbrains.charisma.customfields.simple.period.PeriodProjectCustomFieldImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.workflow.annotations.ApiClass;
import jetbrains.youtrack.api.workflow.annotations.ApiDoc;
import jetbrains.youtrack.core.legacy.XdLegacyEntityType;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettings;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettingsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiClass
@ApiDoc(value="Represents a custom field in a project that stores a value as a period type.\nWe use org.joda.time.Period as a base class for period values.\nWhile you can read the class documentation at\nhttp://joda-time.sourceforge.net/apidocs/org/joda/time/Period.html,\nplease note that we support only class members which use the Period class and\nprimitive types like String and int.\n@example\n// to convert period to minutes (or other units) use get* methods:\nvar period = issue.fields.Estimation;\nvar minutes = !period ? 0 : (period.getMinutes() +\n                             60 * (period.getHours() +\n                                   8 * period.getDays()));\n// to create Period instance, use toPeriod function from date-time module:\nissue.fields.Estimation = dateTime.toPeriod(3 * 3600 * 1000); // 3h in ms\nissue.fields.Estimation = dateTime.toPeriod('3h'); // short form\nissue.fields.Estimation = dateTime.toPeriod('2w4d3h15m'); // full form")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\r\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\f"}, d2={"Ljetbrains/youtrack/timetracking/persistence/XdPeriodProjectCustomField;", "Ljetbrains/charisma/customfields/simple/common/persistence/XdSimpleProjectCustomField;", "entity", "Ljetbrains/exodus/entitystore/Entity;", "(Ljetbrains/exodus/entitystore/Entity;)V", "clearTimeTrackingValues", "", "clearTimeTrackingValues$youtrack_time_tracking", "isWriteAccessible", "", "isWriteAccessible$youtrack_time_tracking", "Companion", "youtrack-time-tracking"})
public final class XdPeriodProjectCustomField
extends XdSimpleProjectCustomField {
    public static final Companion Companion = new Companion(null);

    public final boolean isWriteAccessible$youtrack_time_tracking() {
        XdTimeTrackingSettings settings = XdTimeTrackingSettingsKt.getTimeTrackingSettings(this.getProject());
        if (!settings.getEnabled()) {
            return true;
        }
        return Intrinsics.areEqual((Object)((Object)settings.getSpentTime()), (Object)((Object)this)) ^ true;
    }

    public final void clearTimeTrackingValues$youtrack_time_tracking() {
        XdTimeTrackingSettings settings = XdTimeTrackingSettingsKt.getTimeTrackingSettings(this.getProject());
        if (Intrinsics.areEqual((Object)((Object)settings.getEstimate()), (Object)((Object)this))) {
            settings.setEstimate(null);
        } else if (Intrinsics.areEqual((Object)((Object)settings.getSpentTime()), (Object)((Object)this))) {
            settings.setSpentTime(null);
        }
    }

    public XdPeriodProjectCustomField(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        super(entity);
    }

    public static final /* synthetic */ void access$init(XdPeriodProjectCustomField $this, @NotNull XdCustomFieldPrototype prototype, @NotNull XdProject project2) {
        $this.init(prototype, project2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J3\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u001b\b\u0002\u0010\n\u001a\u0015\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/timetracking/persistence/XdPeriodProjectCustomField$Companion;", "Ljetbrains/youtrack/core/legacy/XdLegacyEntityType;", "Ljetbrains/charisma/customfields/simple/period/PeriodProjectCustomFieldImpl;", "Ljetbrains/youtrack/timetracking/persistence/XdPeriodProjectCustomField;", "()V", "new", "prototype", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "project", "Ljetbrains/youtrack/persistent/XdProject;", "init", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "youtrack-time-tracking"})
    public static final class Companion
    extends XdLegacyEntityType<PeriodProjectCustomFieldImpl, XdPeriodProjectCustomField> {
        @NotNull
        public final XdPeriodProjectCustomField new(@NotNull XdCustomFieldPrototype prototype, @NotNull XdProject project2, @Nullable Function1<? super XdPeriodProjectCustomField, Unit> init) {
            XdEntity xdEntity;
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)prototype, (String)"prototype");
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                xdEntity = super.new((Function1)new Function1<XdPeriodProjectCustomField, Unit>(prototype, project2){
                    final /* synthetic */ XdCustomFieldPrototype $prototype;
                    final /* synthetic */ XdProject $project;

                    public final void invoke(@NotNull XdPeriodProjectCustomField $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                        XdPeriodProjectCustomField.access$init($receiver, this.$prototype, this.$project);
                        $receiver.setNullValueText("?");
                    }
                    {
                        this.$prototype = xdCustomFieldPrototype;
                        this.$project = xdProject;
                        super(1);
                    }
                });
                XdPeriodProjectCustomField $receiver = (XdPeriodProjectCustomField)xdEntity;
                Function1<? super XdPeriodProjectCustomField, Unit> function1 = init;
                if (function1 == null) break block0;
                Unit cfr_ignored_0 = (Unit)function1.invoke((Object)$receiver);
            }
            return (XdPeriodProjectCustomField)xdEntity;
        }

        @NotNull
        public static /* synthetic */ XdPeriodProjectCustomField new$default(Companion companion, XdCustomFieldPrototype xdCustomFieldPrototype, XdProject xdProject, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = null;
            }
            return companion.new(xdCustomFieldPrototype, xdProject, (Function1<? super XdPeriodProjectCustomField, Unit>)function1);
        }

        private Companion() {
            super(null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

