/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.upsource.changes;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import java.util.Set;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.ring.RingAPI;
import jetbrains.youtrack.api.ring.RingDataStore;
import jetbrains.youtrack.integration.vcs.ChangesProcessorImpl;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.upsource.changes.UpsourceServerImpl;
import jetbrains.youtrack.upsource.dto.UpsourceChangeDTO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

public class UpsourceChangesProcessorImpl
extends ChangesProcessorImpl {
    private static String __ENTITY_TYPE__ = "UpsourceChangesProcessor";
    protected static Log log = LogFactory.getLog(UpsourceChangesProcessorImpl.class);

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(Entity project, String upsourceHubResourceKey, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"project", (Entity)project);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"upsourceHubResourceKey", (Comparable)((Object)upsourceHubResourceKey), String.class);
        return entity;
    }

    public boolean isAccessible(Entity user, Entity entity) {
        String permissionId = ((UpsourceServerImpl)DnqUtils.getPersistentClassInstance((Entity)DnqUtils.cast((Object)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"UpsourceServer"), (String)"UpsourceServer")).getReadRevisionsPermissionId(DnqUtils.cast((Object)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"UpsourceServer"));
        if (permissionId == null) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logError("Failed to find id of a permission that defines if a user has access to an Upsource project", entity);
            return false;
        }
        String userRingId = ((RingDataStore)ServiceLocator.getBean((String)"ringDataStore")).getUserRingId(user);
        if (userRingId == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("ring id is not specified for " + (String)PrimitiveAssociationSemantics.get((Entity)user, (String)"login", String.class, (Object)"<no user>")));
            }
            return false;
        }
        Set accessibleProjectIds = ((RingAPI)ServiceLocator.getBean((String)"ringApi")).getPermissionCache().user(userRingId, true).withPermission(permissionId).getAccessibleProjects();
        String globaProjectId = ((RingAPI)ServiceLocator.getBean((String)"ringApi")).getProjectDAO().getGlobal().getId();
        String projectRingId = UpsourceServerImpl.getProjectRingId(AssociationSemantics.getToOne((Entity)entity, (String)"project"));
        return accessibleProjectIds.contains(projectRingId) || accessibleProjectIds.contains(globaProjectId);
    }

    protected String getLogPrefix(Entity entity) {
        return "Upsource Integration [" + (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"project"), (String)"shortName", String.class, null) + "<-" + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"upsourceProjectName", String.class, null) + "(" + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"upsourceHubResourceKey", String.class, null) + ")]: ";
    }

    public String getChangeHref(CommonChangeDTO changeDto, Entity entity) {
        return (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"url", String.class, null) + "/" + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"upsourceHubResourceKey", String.class, null) + "/revision/" + changeDto.version;
    }

    public CommonChangeDTO toDto(Entity change, Entity entity) {
        return new UpsourceChangeDTO(change);
    }

    public static Entity constructor(Entity project, String upsourceHubResourceKey) {
        return ((UpsourceChangesProcessorImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(project, upsourceHubResourceKey, __ENTITY_TYPE__);
    }

    protected static DnqUtils.QueryingEntityCreator getEntityCreator(String entityType, Entity project, String upsourceHubResourceKey, final Set<String> queriedParams) {
        final DnqUtils.QueryingEntityCreator parent = DnqUtils.getEntityCreator((String)entityType, queriedParams);
        final Entity __var__project = project;
        final String __var__upsourceHubResourceKey = upsourceHubResourceKey;
        return new DnqUtils.QueryingEntityCreator(entityType){

            public Iterable<Entity> query() {
                Iterable result = parent.query();
                if (queriedParams.contains("project")) {
                    result = QueryOperations.query((Iterable)result, (String)"UpsourceChangesProcessor", (NodeBase)new LinkEqual("project", __var__project));
                }
                if (queriedParams.contains("upsourceHubResourceKey")) {
                    result = QueryOperations.query((Iterable)result, (String)"UpsourceChangesProcessor", (NodeBase)new PropertyEqual("upsourceHubResourceKey", (Comparable)((Object)__var__upsourceHubResourceKey)));
                }
                return result;
            }

            public void created(@NotNull Entity entity) {
                parent.created(entity);
                DirectedAssociationSemantics.setToOne((Entity)entity, (String)"project", (Entity)__var__project);
                PrimitiveAssociationSemantics.set((Entity)entity, (String)"upsourceHubResourceKey", (Comparable)((Object)__var__upsourceHubResourceKey), String.class);
            }
        };
    }

    public static Entity findOrCreate(Entity project, String upsourceHubResourceKey, String[] queriedParams) {
        return UpsourceChangesProcessorImpl.getEntityCreator(__ENTITY_TYPE__, project, upsourceHubResourceKey, BasePersistentClassImpl.buildSet((Object[])queriedParams)).create((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore"));
    }
}

