/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.upsource.rest;

import com.intellij.hub.auth.oauth2.token.AccessToken;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import jetbrains.charisma.rest.JacksonObjectMapperProvider;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.IMapping;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.ring.HubAuthenticationClient;
import jetbrains.youtrack.core.ssl.SSLContextFactory;
import jetbrains.youtrack.upsource.rest.UpsourceChange;
import jetbrains.youtrack.upsource.rest.UpsourceCommits;
import jetbrains.youtrack.upsource.rest.UpsourceException;
import jetbrains.youtrack.upsource.rest.UpsourceProject;
import jetbrains.youtrack.upsource.rest.UpsourceResponse;
import jetbrains.youtrack.upsource.rest.UpsourceResult;
import jetbrains.youtrack.upsource.rest.UpsourceVersion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import webr.framework.controller.CentralManager;

public class UpsourceRest {
    private static final int MAX_TIMEOUT = 300;
    protected static Log log = LogFactory.getLog(UpsourceRest.class);
    private WebTarget wr;
    private String version;

    public UpsourceRest(String serverUrl, int socketTimeOut, int readTimeOut, Entity sslKey) {
        if (socketTimeOut <= 0 || socketTimeOut > 300) {
            socketTimeOut = 300;
        }
        if (readTimeOut <= 0 || readTimeOut > 300) {
            readTimeOut = 300;
        }
        ClientBuilder config = ((ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JacksonObjectMapperProvider.class)).register(JacksonFeature.class)).property("jersey.config.client.connectTimeout", (Object)(socketTimeOut * 1000))).property("jersey.config.client.readTimeout", (Object)(readTimeOut * 1000))).sslContext(((SSLContextFactory)ServiceLocator.getBean((String)"sslContextFactory")).createContext(sslKey));
        Client c = config.build();
        this.wr = c.target(serverUrl == null ? null : serverUrl.trim());
    }

    public Tuples._2<Iterable<UpsourceChange>, String> getChanges(String projectId, String hash, Iterable<String> substrings) {
        IMapSequence params = MapSequence.fromMap(new HashMap());
        MapSequence.fromMap((Map)params).put((Object)"projectId", (Object)projectId);
        MapSequence.fromMap((Map)params).put((Object)"limit", (Object)100);
        MapSequence.fromMap((Map)params).put((Object)"hash", (Object)(hash == null ? "" : hash));
        if (Sequence.fromIterable(substrings).isNotEmpty()) {
            MapSequence.fromMap((Map)params).put((Object)"messageSubstring", (Object)("[" + IterableUtils.join((Iterable)Sequence.fromIterable(substrings).select((_FunctionTypes._return_P1_E0)new ISelector<String, String>(){

                public String select(String it) {
                    return "\"" + it + "\"";
                }
            }), (String)",") + "]"));
        }
        Invocation.Builder restResource = this.restResource("/getRevisionsListUpdate", (Map<String, Object>)params);
        UpsourceResult result = this.getResult(restResource);
        return MultiTuple.from(result.changes, (Object)result.hash);
    }

    public Iterable<UpsourceProject> getProjects() {
        return this.getResult((Invocation.Builder)this.restResource((String)"/getAllProjects", null)).projects;
    }

    public UpsourceProject getProject(final String projectId) {
        return (UpsourceProject)Sequence.fromIterable(this.getProjects()).findFirst((_FunctionTypes._return_P1_E0)new IWhereFilter<UpsourceProject>(){

            public boolean accept(UpsourceProject it) {
                return it.projectId.equalsIgnoreCase(projectId);
            }
        });
    }

    public <T> T get(Invocation.Builder builder, Class<T> c) {
        try {
            return (T)builder.get(c);
        }
        catch (Exception e) {
            throw new LocalizedLogicException(e);
        }
    }

    public <T> UpsourceResult getResult(Invocation.Builder target) {
        UpsourceResponse response = (UpsourceResponse)target.get(UpsourceResponse.class);
        if (response.error != null) {
            throw new UpsourceException(response.error);
        }
        if (response.result == null) {
            throw new RuntimeException("Unexpected response format: neither result no error provided");
        }
        return response.result;
    }

    private Invocation.Builder restResource(String path, Map<String, Object> params) {
        path = "/~rpc" + path;
        return this.someResource(path, params);
    }

    private Invocation.Builder someResource(String path, Map<String, Object> params) throws LocalizedLogicException {
        try {
            String paramsString = IterableUtils.join((Iterable)MapSequence.fromMap(params).select((_FunctionTypes._return_P1_E0)new ISelector<IMapping<String, Object>, String>(){

                public String select(IMapping<String, Object> it) {
                    String quotes = it.value() instanceof String && !((String)it.value()).startsWith("[") ? "\"" : "";
                    return "\"" + (String)it.key() + "\":" + quotes + it.value() + quotes;
                }
            }), (String)",");
            WebTarget _wr = this.wr.path(path);
            if (paramsString != null && paramsString.length() > 0) {
                _wr = _wr.queryParam("params", new Object[]{URLEncoder.encode("{" + paramsString + "}", "UTF-8").replace("+", "%20")});
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Upsource REST client. Calling " + _wr));
            }
            return _wr.request().header("Authorization", (Object)AccessToken.Companion.encodeHeader(((HubAuthenticationClient)ServiceLocator.getBean((String)"hubAuthenticationClient")).loginAsHubService())).header("user-agent", (Object)(((CentralManager)ServiceLocator.getBean((String)"centralManager")).getApplicationName() + "/" + ((CentralManager)ServiceLocator.getBean((String)"centralManager")).getAppicationVersion() + " (build #" + ((CentralManager)ServiceLocator.getBean((String)"centralManager")).getAppicationBuild() + "). Base URL: " + (String)PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"notificationsConfig")), (String)"baseUrl", String.class, null)));
        }
        catch (Exception e) {
            throw new LocalizedLogicException(e);
        }
    }

    public UpsourceChange getCommit(String projectId, String hash) {
        IMapSequence params = MapSequence.fromMap(new HashMap());
        MapSequence.fromMap((Map)params).put((Object)"commits", (Object)("[{\"projectId\":\"" + projectId + "\",\"revisionId\":\"" + hash + "\"}]"));
        try {
            UpsourceResult result = this.getResult(this.restResource("/findCommits", (Map<String, Object>)params));
            return ListSequence.fromList(result.commits).isNotEmpty() && ListSequence.fromList(((UpsourceCommits)ListSequence.fromList(result.commits).first()).commits).isNotEmpty() ? ((UpsourceCommits)ListSequence.fromList(((UpsourceCommits)ListSequence.fromList(result.commits).first()).commits).first()).change : null;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Exception when getting an Upsource commit " + hash + " in project " + projectId), (Throwable)e);
            }
            return null;
        }
    }

    public void test() {
        this.version = ((UpsourceVersion)this.someResource((String)"/~version", null).get(UpsourceVersion.class)).server;
    }
}

