/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.teamcity.persistence;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;

public class CommandExecutionInfo
implements Externalizable {
    private static final long serialVersionUID = -5709006385987370604L;
    private String errorText;
    private int myStart;
    private int myEnd;
    private boolean myIsError;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public CommandExecutionInfo() {
    }

    public CommandExecutionInfo(int start, int end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public void setErrorText(String errorText) {
        this.setIsError(true);
        this.errorText = errorText;
    }

    public String getErrorText() {
        return this.errorText;
    }

    @Override
    @Deprecated
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setStart(in.readInt());
        this.setEnd(in.readInt());
        this.setIsError(in.readBoolean());
        this.errorText = (String)in.readObject();
    }

    @Override
    @Deprecated
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.getStart());
        out.writeInt(this.getEnd());
        out.writeBoolean(this.getIsError());
        out.writeObject(this.errorText);
    }

    public int getStart() {
        return this.myStart;
    }

    public void setStart(int value) {
        this.myStart = value;
    }

    public int getEnd() {
        return this.myEnd;
    }

    public void setEnd(int value) {
        this.myEnd = value;
    }

    public boolean getIsError() {
        return this.myIsError;
    }

    public void setIsError(boolean value) {
        this.myIsError = value;
    }

    @Deprecated
    public static Iterable<CommandExecutionInfo> deserialize(InputStream inputStream) throws IOException {
        ObjectInputStream in = new ObjectInputStream(inputStream);
        int size = in.readInt();
        IListSequence ret = ListSequence.fromList(new ArrayList(size));
        try {
            for (int count = 0; count < size; ++count) {
                ListSequence.fromList((List)ret).addElement((Object)((CommandExecutionInfo)in.readObject()));
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        in.close();
        return ret;
    }

    @Deprecated
    public static InputStream serialize(Iterable<CommandExecutionInfo> commandExecutionInfos) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeInt(Sequence.fromIterable(commandExecutionInfos).count());
        for (CommandExecutionInfo info : Sequence.fromIterable(commandExecutionInfos)) {
            out.writeObject(info);
        }
        out.flush();
        out.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static String marshal(Iterable<CommandExecutionInfo> infos) {
        try {
            return OBJECT_MAPPER.writeValueAsString(infos);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Iterable<CommandExecutionInfo> unmarshal(String text) throws IOException {
        return (Iterable)OBJECT_MAPPER.readValue(text, (TypeReference)new TypeReference<List<CommandExecutionInfo>>(){});
    }
}

