/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.misc;

import java.util.concurrent.ConcurrentHashMap;
import jetbrains.exodus.entitystore.Entity;

public class ProgressStateHolder {
    private ConcurrentHashMap<Entity, Class<ProgressStateHolder>> progress = new ConcurrentHashMap();
    private ConcurrentHashMap<Entity, String> progressMessages = new ConcurrentHashMap();
    private ConcurrentHashMap<Entity, String> stateMessages = new ConcurrentHashMap();

    public boolean isRunning(Entity p) {
        return this.progress.containsKey(p);
    }

    public boolean startRun(Entity p) {
        return this.progress.putIfAbsent(p, ProgressStateHolder.class) == null;
    }

    public void endRun(Entity p) {
        this.progress.remove(p);
    }

    public String getStateMessage(Entity p) {
        return this.get(this.stateMessages, p);
    }

    public void setStateMessage(Entity p, String m) {
        this.set(this.stateMessages, p, m);
    }

    public String getProgressMessage(Entity p) {
        return this.get(this.progressMessages, p);
    }

    public void setProgressMessage(Entity p, String m) {
        this.set(this.progressMessages, p, m);
    }

    private void set(ConcurrentHashMap<Entity, String> target, Entity p, String m) {
        if (m == null || m.length() == 0) {
            target.remove(p);
        } else {
            target.put(p, m);
        }
    }

    public String get(ConcurrentHashMap<Entity, String> target, Entity p) {
        String val = target.get(p);
        return val == null ? "" : val;
    }
}

