/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.Or;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.baseLanguage.closures.runtime.YieldingIterator;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequenceClosure;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.statistics.StatisticsFeatureDescription;
import jetbrains.youtrack.api.statistics.StatisticsService;
import jetbrains.youtrack.core.dates.DateFormats;
import jetbrains.youtrack.integration.misc.ProgressStateHolder;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.StringUtils;
import jetbrains.youtrack.integration.vcs.VcsServerImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

public class ChangesProcessorImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "ChangesProcessor";
    private static final Pattern COMMENT_PATTERN = Pattern.compile(".+?(\n\n+)", 32);
    private static final Pattern ISSUE_ID = Pattern.compile("[a-zA-Z0-9_]+\\-\\d+");
    protected static Log log = LogFactory.getLog(ChangesProcessorImpl.class);

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"enabled", (Comparable)Boolean.valueOf(true), Boolean.class);
        return entity;
    }

    protected void doProcess(_FunctionTypes._return_P1_E0<? extends Iterable<CommonChangeDTO>, ? super Entity> changesProvider, final Entity entity) {
        try {
            while (true) {
                Iterable changes = (Iterable)changesProvider.invoke((Object)entity);
                ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("Processing changes " + IterableUtils.join((Iterable)Sequence.fromIterable((Iterable)changes).select((_FunctionTypes._return_P1_E0)new ISelector<CommonChangeDTO, String>(){

                    public String select(CommonChangeDTO it) {
                        return it.id;
                    }
                }), (String)" "), entity);
                if (Sequence.fromIterable((Iterable)changes).isEmpty()) {
                    this.setProgressMessage(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ChangesProcessor.No_new_changes_found", new Object[0]), entity);
                    if (((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"taxidermy", Boolean.class, null)).booleanValue()) {
                        ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("Switching off taxidermy mode", entity);
                        PrimitiveAssociationSemantics.set((Entity)entity, (String)"taxidermy", (Comparable)Boolean.valueOf(false), Boolean.class);
                    }
                    break;
                }
                this.setProgressMessage(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TeamcityBuildConfMapping.Link_issues_with_changes_Revisions_from_{0}_to_{1}", new Object[]{((CommonChangeDTO)Sequence.fromIterable((Iterable)changes).first()).version, ((CommonChangeDTO)Sequence.fromIterable((Iterable)changes).last()).version}), entity);
                Sequence.fromIterable((Iterable)changes).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<CommonChangeDTO>(){

                    public void visit(CommonChangeDTO it) {
                        ChangesProcessorImpl.this.processChange(it, entity);
                    }
                });
                DnqUtils.getCurrentTransientSession().flush();
            }
        }
        catch (Exception e) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logException(e, "Failed to process changes", true, true, entity);
        }
    }

    public void processChange(CommonChangeDTO c, Entity entity) {
        String comment = c.comment;
        ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logDebug("Process change [" + c.id + "] with comment [" + comment + "]", entity);
        Matcher commentMatcher = COMMENT_PATTERN.matcher(comment);
        if (commentMatcher.matches()) {
            comment = StringUtils.substring(comment, 0, commentMatcher.start(1));
        }
        ((StatisticsService)ServiceLocator.getBean((String)"statService")).incForInstance(new StatisticsFeatureDescription("vcs", entity.getType() + ".changeProcessed"));
        try {
            for (Entity issue : Sequence.fromIterable(ChangesProcessorImpl.extractIssues(comment))) {
                if (EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)issue, (String)"project"), (Object)AssociationSemantics.getToOne((Entity)entity, (String)"project"))) {
                    ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).addChange(c, issue, entity);
                    continue;
                }
                ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("issue " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue) + " belogs to a different project. Skipping", entity);
            }
        }
        catch (Exception e) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logException(e, "Exception while processing change [" + c.id + "]", true, false, entity);
        }
    }

    @NotNull
    public Entity addChange(CommonChangeDTO change, Entity issue, Entity entity) {
        Entity existing = ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).findExisting(change, issue, entity);
        if (EntityOperations.equals((Entity)existing, null)) {
            change.issue = issue;
            return change.createNewEntity();
        }
        DirectedAssociationSemantics.createToMany((Entity)existing, (String)"processors", (Entity)entity);
        change.appendToExistingEntity(existing);
        return existing;
    }

    private Entity findExisting(final CommonChangeDTO change, Entity issue, Entity entity) {
        String version = change.version;
        IListSequence withIdenticalVersion = Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"VcsChange", (NodeBase)new And((NodeBase)new LinkEqual("issue", issue), (NodeBase)new Or((NodeBase)new PropertyEqual("version", (Comparable)((Object)version)), (NodeBase)new PropertyEqual("version", (Comparable)((Object)change.id)))))).toListSequence();
        if (QueryOperations.isEmpty((Iterable)withIdenticalVersion)) {
            return null;
        }
        if (version.length() > 10) {
            return QueryOperations.getFirst((Iterable)withIdenticalVersion);
        }
        return QueryOperations.getFirst((Iterable)Sequence.fromIterable((Iterable)withIdenticalVersion).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return change.comment == null && PrimitiveAssociationSemantics.getBlobAsString((Entity)it, (String)"comment") == null || change.comment.equals(PrimitiveAssociationSemantics.getBlobAsString((Entity)it, (String)"comment"));
            }
        }));
    }

    public boolean isAccessible(Entity user2, Entity entity) {
        if (!this.isEnabled(entity)) {
            return false;
        }
        if (EntityOperations.equals((Entity)user2, null)) {
            return false;
        }
        if (QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"visibleForGroups"))) {
            return true;
        }
        return !QueryOperations.isEmpty((Iterable)QueryOperations.intersect((Iterable)((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user2, (String)"User")).getUserGroups(user2), (Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"visibleForGroups")));
    }

    protected String getLogPrefix(Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    public void setProgressMessage(String message, Entity entity) {
        ((ProgressStateHolder)ServiceLocator.getBean((String)"progressStateHoder")).setProgressMessage(entity, message);
    }

    protected void addStateMessage(String message, Entity entity) {
        String stateMessage = ((ProgressStateHolder)ServiceLocator.getBean((String)"progressStateHoder")).getStateMessage(entity);
        ((ProgressStateHolder)ServiceLocator.getBean((String)"progressStateHoder")).setStateMessage(entity, stateMessage == null || stateMessage.length() == 0 ? message : stateMessage + "\n" + message);
    }

    public void logException(Exception e, String message, boolean asError, boolean addStateMessage, Entity entity) {
        if (addStateMessage) {
            this.addStateMessage(e.getMessage(), entity);
        }
        String m = this.getLogPrefix(entity) + message + ". Reason: ";
        if (asError) {
            if (log.isErrorEnabled()) {
                log.error((Object)m, (Throwable)e);
            }
        } else {
            if (log.isWarnEnabled()) {
                log.warn((Object)(m + e.getMessage()));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)m, (Throwable)e);
            }
        }
    }

    public void logInfo(String message, Entity entity) {
        if (log.isInfoEnabled()) {
            log.info((Object)(this.getLogPrefix(entity) + message));
        }
    }

    public void logDebug(String message, Entity entity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getLogPrefix(entity) + message));
        }
    }

    public void logError(String message, Entity entity) {
        if (log.isErrorEnabled()) {
            log.error((Object)(this.getLogPrefix(entity) + message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(_FunctionTypes._return_P1_E0<? extends Iterable<CommonChangeDTO>, ? super Entity> changesProvider, Entity entity) {
        if (!this.isEnabled(entity)) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("Mapping disabled. Return", entity);
            return;
        }
        ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("Process configuration", entity);
        ProgressStateHolder stateHolder = (ProgressStateHolder)ServiceLocator.getBean((String)"progressStateHoder");
        if (!stateHolder.startRun(entity)) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("Already in progress. Return.", entity);
            return;
        }
        try {
            this.initMessages(entity);
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).doProcess(changesProvider, entity);
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).setSynchrinizedAt(entity);
        }
        finally {
            stateHolder.endRun(entity);
        }
    }

    public void setSynchrinizedAt(Entity entity) {
        this.addStateMessage(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TeamcityBuildConfMapping.Synchronized_at_{0}", new Object[]{DateTimeOperations.print((DateTime)DateTimeOperations.convert((Long)System.currentTimeMillis(), (DateTimeZone)((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"ApplicationMetaData")).getTimeZone((Entity)ServiceLocator.getBean((String)"applicationMetaData"))), (DateTimeFormatter)DateFormats.INSTANCE.getFormatter("gmailLike"), (Locale)((Localizer)ServiceLocator.getBean((String)"localizer")).getLocale())}), entity);
    }

    public void initMessages(Entity entity) {
        ((ProgressStateHolder)ServiceLocator.getBean((String)"progressStateHoder")).setStateMessage(entity, null);
        this.setProgressMessage(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TeamcityBuildConfMapping.Synchronizing", new Object[0]), entity);
    }

    public String getChangeHref(CommonChangeDTO changeDto, Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    public CommonChangeDTO toDto(Entity change, Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    public boolean isEnabled(Entity entity) {
        return ((VcsServerImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"VcsServer")).isEnabled(AssociationSemantics.getToOne((Entity)entity, (String)"server")) && (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"enabled", Boolean.class, null) != false;
    }

    public boolean canAttachChanges(Entity entity) {
        return ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).isEnabled(entity);
    }

    public static Entity constructor() {
        return ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    public static Iterable<Entity> extractIssues(String changeComment) {
        return QueryOperations.distinct((Iterable)Sequence.fromIterable(ChangesProcessorImpl.extractIssuesIds(changeComment)).select((_FunctionTypes._return_P1_E0)new ISelector<String, Entity>(){

            public Entity select(String it) {
                return IssueImpl.fromId((String)it);
            }
        }).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !EntityOperations.equals((Entity)it, null);
            }
        }));
    }

    public static Iterable<String> extractIssuesIds(String changeComment) {
        if (changeComment == null || changeComment.length() == 0) {
            return Sequence.fromIterable(Collections.emptyList());
        }
        final Matcher m = ISSUE_ID.matcher(changeComment);
        return Sequence.fromClosure((_FunctionTypes._return_P0_E0)new ISequenceClosure<String>(){

            public Iterable<String> iterable() {
                return new Iterable<String>(){

                    @Override
                    public Iterator<String> iterator() {
                        return new YieldingIterator<String>(){
                            private int __CP__ = 0;

                            protected boolean moveToNext() {
                                block7: while (true) {
                                    switch (this.__CP__) {
                                        case -1: {
                                            assert (false) : "Internal error";
                                            return false;
                                        }
                                        case 2: {
                                            if (m.find()) {
                                                this.__CP__ = 3;
                                                continue block7;
                                            }
                                            this.__CP__ = 1;
                                            continue block7;
                                        }
                                        case 4: {
                                            this.__CP__ = 2;
                                            this.yield(m.group());
                                            return true;
                                        }
                                        case 0: {
                                            this.__CP__ = 2;
                                            continue block7;
                                        }
                                        case 3: {
                                            this.__CP__ = 4;
                                            continue block7;
                                        }
                                    }
                                    break;
                                }
                                return false;
                            }
                        };
                    }
                };
            }
        });
    }
}

