/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.workflow.checker;

import java.util.ArrayList;
import jetbrains.youtrack.api.workflow.wrappers.TypedValueResolver;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdIssueLinkPrototype;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.scripts.model.AbstractScriptingContext;
import jetbrains.youtrack.scripts.wrappers.EntityValueResolver;
import jetbrains.youtrack.workflow.checker.BeansKt;
import jetbrains.youtrack.workflow.checker.TypeChecker;
import jetbrains.youtrack.workflow.checker.TypeCheckerKt;
import jetbrains.youtrack.workflow.checker.TypeProblemListener;
import jetbrains.youtrack.workflow.checker.WorkflowChecker;
import jetbrains.youtrack.workflow.checker.problem.ActionNameIsNotUniqueProblem;
import jetbrains.youtrack.workflow.checker.problem.BadCardinalityProblem;
import jetbrains.youtrack.workflow.checker.problem.BadTypeNameProblem;
import jetbrains.youtrack.workflow.checker.problem.IncompatibleVersionProblem;
import jetbrains.youtrack.workflow.checker.problem.NoSuchFieldProblem;
import jetbrains.youtrack.workflow.checker.problem.NoSuchIssueLinkProblem;
import jetbrains.youtrack.workflow.checker.problem.ValidationProblem;
import jetbrains.youtrack.workflow.model.RequirementsValidationContext;
import jetbrains.youtrack.workflow.model.Rule;
import jetbrains.youtrack.workflow.model.StatelessActionRule;
import jetbrains.youtrack.workflow.persistence.ScriptExtensionsKt;
import jetbrains.youtrack.workflow.persistence.XdWorkflowUser;
import jetbrains.youtrack.workflow.requirement.FieldRequirement;
import jetbrains.youtrack.workflow.requirement.TypeRequirement;
import jetbrains.youtrack.workflow.wrappers.XdValueResolveUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bJ\b\u0010\u001c\u001a\u00020\u0014H\u0002J\n\u0010\u001d\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010!\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Ljetbrains/youtrack/workflow/checker/WorkflowChecker;", "Ljetbrains/youtrack/workflow/checker/TypeProblemListener;", "rule", "Ljetbrains/youtrack/workflow/model/Rule;", "project", "Ljetbrains/youtrack/persistent/XdProject;", "resolveUtil", "Ljetbrains/youtrack/workflow/wrappers/XdValueResolveUtil;", "(Ljetbrains/youtrack/workflow/model/Rule;Ljetbrains/youtrack/persistent/XdProject;Ljetbrains/youtrack/workflow/wrappers/XdValueResolveUtil;)V", "checker", "Ljetbrains/youtrack/workflow/checker/TypeChecker;", "problems", "Ljava/util/ArrayList;", "Ljetbrains/youtrack/workflow/checker/problem/ValidationProblem;", "Lkotlin/collections/ArrayList;", "getProject", "()Ljetbrains/youtrack/persistent/XdProject;", "getRule", "()Ljetbrains/youtrack/workflow/model/Rule;", "badCardinality", "", "fieldRequirement", "Ljetbrains/youtrack/workflow/requirement/FieldRequirement;", "resolver", "Ljetbrains/youtrack/api/workflow/wrappers/TypedValueResolver;", "badTypeName", "check", "", "checkActionNameIsUnique", "checkVersion", "noSuchField", "typeRequirement", "Ljetbrains/youtrack/workflow/requirement/TypeRequirement;", "noSuchValue", "typeResolver", "Ljetbrains/youtrack/scripts/wrappers/EntityValueResolver;", "value", "", "youtrack-workflow"})
public final class WorkflowChecker
implements TypeProblemListener {
    private final ArrayList<ValidationProblem> problems;
    private final TypeChecker checker;
    @NotNull
    private final Rule rule;
    @NotNull
    private final XdProject project;
    private final XdValueResolveUtil resolveUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Iterable<ValidationProblem> check() {
        Rule rule2 = this.rule;
        ValidationProblem validationProblem = this.checkVersion();
        if (validationProblem != null) {
            ValidationProblem validationProblem2;
            ValidationProblem it = validationProblem2 = validationProblem;
            return CollectionsKt.listOf((Object)it);
        }
        this.checkActionNameIsUnique();
        jetbrains.youtrack.scripts.persistent.BeansKt.getScriptingContextHolder().set((AbstractScriptingContext)new RequirementsValidationContext(rule2, this.project));
        try {
            jetbrains.charisma.main.BeansKt.getPrincipalManager().setTemporaryServerPrincipal((Object)((XdWorkflowUser)XdWorkflowUser.Companion.get()).getEntity());
            for (TypeRequirement typeRequirement : rule2.getRequirements()) {
                EntityValueResolver entityValueResolver = this.resolveUtil.getProjectEntityValueResolver(null, this.project.getEntity(), typeRequirement.getName(), false);
                Intrinsics.checkExpressionValueIsNotNull((Object)entityValueResolver, (String)"resolveUtil.getProjectEn\u2026eRequirement.name, false)");
                this.checker.check(typeRequirement, entityValueResolver);
            }
        }
        finally {
            jetbrains.charisma.main.BeansKt.getPrincipalManager().unsetTemporaryServerPrincipal();
            jetbrains.youtrack.scripts.persistent.BeansKt.getScriptingContextHolder().remove();
        }
        return this.problems;
    }

    private final ValidationProblem checkVersion() {
        ValidationProblem validationProblem;
        String version = this.rule.getXdScript().getWorkflow().getMinimalApiVersion();
        String string = version;
        if (string != null && (string = StringsKt.substringAfterLast$default((String)string, (String)".", null, (int)2, null)) != null) {
            ValidationProblem validationProblem2;
            String string2;
            String buildNumberStr = string2 = string;
            try {
                int required = Integer.parseInt(buildNumberStr);
                int actual = Integer.parseInt(jetbrains.youtrack.config.BeansKt.getCentralManager().getAppicationBuild());
                validationProblem2 = required > actual ? (ValidationProblem)new IncompatibleVersionProblem(jetbrains.youtrack.config.BeansKt.getCentralManager().getAppicationVersion() + '.' + actual, String.valueOf(version)) : null;
            }
            catch (NumberFormatException ex) {
                validationProblem2 = null;
            }
            validationProblem = validationProblem2;
        } else {
            validationProblem = null;
        }
        return validationProblem;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkActionNameIsUnique() {
        block3: {
            StatelessActionRule olderConflictingRule;
            Object v0;
            Object object;
            block2: {
                void $receiver$iv;
                if (!(this.rule instanceof StatelessActionRule)) break block3;
                checkActionNameIsUnique.1 conflictsWith$ = checkActionNameIsUnique.1.INSTANCE;
                checkActionNameIsUnique.2 isNewerThan$ = checkActionNameIsUnique.2.INSTANCE;
                object = ScriptExtensionsKt.getApplicableActionRulesTill(this.project, this.rule);
                for (Object element$iv : $receiver$iv) {
                    StatelessActionRule it = (StatelessActionRule)element$iv;
                    if (!(checkActionNameIsUnique.1.INSTANCE.invoke((StatelessActionRule)this.rule, it) && checkActionNameIsUnique.2.INSTANCE.invoke((StatelessActionRule)this.rule, it))) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            StatelessActionRule statelessActionRule = olderConflictingRule = (StatelessActionRule)v0;
            if (statelessActionRule != null) {
                Object it = object = statelessActionRule;
                this.problems.add(new ActionNameIsNotUniqueProblem((StatelessActionRule)it));
            }
        }
    }

    @Override
    public void noSuchField(@NotNull TypeRequirement typeRequirement, @NotNull FieldRequirement fieldRequirement) {
        Intrinsics.checkParameterIsNotNull((Object)typeRequirement, (String)"typeRequirement");
        Intrinsics.checkParameterIsNotNull((Object)fieldRequirement, (String)"fieldRequirement");
        String expectedType = fieldRequirement.getType().getName();
        if (Intrinsics.areEqual((Object)expectedType, (Object)XdIssueLinkPrototype.Companion.getEntityType()) || Intrinsics.areEqual((Object)expectedType, (Object)XdIssue.Companion.getEntityType())) {
            this.problems.add(new NoSuchIssueLinkProblem(this.rule, this.project, typeRequirement, fieldRequirement));
        } else {
            this.problems.add(new NoSuchFieldProblem(this.rule, this.project, typeRequirement, fieldRequirement));
        }
    }

    @Override
    public void noSuchValue(@NotNull TypeRequirement typeRequirement, @NotNull EntityValueResolver typeResolver, @NotNull String value2) {
        Intrinsics.checkParameterIsNotNull((Object)typeRequirement, (String)"typeRequirement");
        Intrinsics.checkParameterIsNotNull((Object)typeResolver, (String)"typeResolver");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        this.problems.add(BeansKt.getWorkflowProblemProvider().createProblem(this.rule, this.project, typeRequirement, typeResolver, value2));
    }

    @Override
    public void badTypeName(@NotNull FieldRequirement fieldRequirement, @NotNull TypedValueResolver resolver) {
        Intrinsics.checkParameterIsNotNull((Object)fieldRequirement, (String)"fieldRequirement");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        this.problems.add(new BadTypeNameProblem(fieldRequirement, resolver));
    }

    @Override
    public void badCardinality(@NotNull FieldRequirement fieldRequirement, @NotNull TypedValueResolver resolver) {
        Intrinsics.checkParameterIsNotNull((Object)fieldRequirement, (String)"fieldRequirement");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        this.problems.add(new BadCardinalityProblem(fieldRequirement, resolver));
    }

    @NotNull
    public final Rule getRule() {
        return this.rule;
    }

    @NotNull
    public final XdProject getProject() {
        return this.project;
    }

    public WorkflowChecker(@NotNull Rule rule2, @NotNull XdProject project2, @NotNull XdValueResolveUtil resolveUtil) {
        Intrinsics.checkParameterIsNotNull((Object)rule2, (String)"rule");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)resolveUtil, (String)"resolveUtil");
        this.rule = rule2;
        this.project = project2;
        this.resolveUtil = resolveUtil;
        WorkflowChecker workflowChecker = this;
        ArrayList arrayList = new ArrayList();
        workflowChecker.problems = arrayList;
        this.checker = TypeCheckerKt.getTypeChecker(this.rule, this.resolveUtil, this);
    }
}

