/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.workflow.persistent;

import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jetbrains.mps.internationalization.runtime.Localization;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.youtrack.scripts.persistence.EvaluationStatus;
import jetbrains.youtrack.scripts.persistence.SimpleEvalStatus;
import jetbrains.youtrack.scripts.persistent.XdScript;
import jetbrains.youtrack.scripts.sandbox.AbstractEvaluationParameters;
import jetbrains.youtrack.scripts.sandbox.SimpleEvalParams;
import jetbrains.youtrack.workflow.ext.RunInContextKt;
import jetbrains.youtrack.workflow.model.Rule;
import jetbrains.youtrack.workflow.persistent.BeansKt;
import jetbrains.youtrack.workflow.persistent.LoadedRulesLocal;
import jetbrains.youtrack.workflow.persistent.LoadedRulesLocalKt;
import jetbrains.youtrack.workflow.persistent.NotARule;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import webr.framework.controller.BaseApplication;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\b\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000bH\u0002\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000bH\u0002\" \u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"currentlyProcessedRules", "Ljava/lang/ThreadLocal;", "", "", "Ljetbrains/youtrack/workflow/model/Rule;", "ignoredPackages", "", "clearRulesAssociatedWithTransaction", "", "doLoadRule", "ruleEntity", "Ljetbrains/youtrack/scripts/persistent/XdScript;", "loadJsRule", "script", "loadMpsRule", "loadRule", "loadRuleAndAssociateWithTransaction", "popRuleFromTransaction", "youtrack-workflow"})
public final class LoadedRulesLocalKt {
    private static final ThreadLocal<Map<String, Rule>> currentlyProcessedRules;
    private static final Set<String> ignoredPackages;

    private static final Rule popRuleFromTransaction(XdScript script) {
        Rule rule2 = currentlyProcessedRules.get().remove(script.getFullName().toString());
        if (rule2 == null) {
            throw (Throwable)new IllegalStateException("Rule " + script.getFullName() + " is not being processed in the current transaction");
        }
        return rule2;
    }

    public static final void loadRuleAndAssociateWithTransaction(@NotNull XdScript script) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Rule rule2 = LoadedRulesLocalKt.loadRule(script);
        LoadedRulesLocal.Companion.getLogger().info((Function0)new Function0<String>(rule2){
            final /* synthetic */ Rule $rule;

            @NotNull
            public final String invoke() {
                return "Loaded rule " + this.$rule.getFqName();
            }
            {
                this.$rule = rule2;
                super(0);
            }
        });
        Map<String, Rule> map = currentlyProcessedRules.get();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"currentlyProcessedRules.get()");
        Map<String, Rule> map2 = map;
        String string = script.getFullName().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"script.fullName.toString()");
        String string2 = string;
        Rule rule3 = rule2;
        map2.put(string2, rule3);
    }

    public static final void clearRulesAssociatedWithTransaction() {
        currentlyProcessedRules.remove();
    }

    private static final Rule loadRule(XdScript script) {
        Rule rule2 = BeansKt.getLoadedRules().getPredefinedRule$youtrack_workflow(script);
        if (rule2 == null) {
            rule2 = LoadedRulesLocalKt.doLoadRule(script);
        }
        return rule2;
    }

    private static final Rule doLoadRule(XdScript ruleEntity) {
        Rule rule2 = (Rule)jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().doInServerLocale((Function0)new Function0<Rule>(ruleEntity){
            final /* synthetic */ XdScript $ruleEntity;

            @Nullable
            public final Rule invoke() {
                return this.$ruleEntity.getWorkflow().isMpsPackage() ? LoadedRulesLocalKt.access$loadMpsRule(this.$ruleEntity) : LoadedRulesLocalKt.access$loadJsRule(this.$ruleEntity);
            }
            {
                this.$ruleEntity = xdScript;
                super(0);
            }
        });
        if (rule2 == null) {
            String string = ruleEntity.getFullName().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ruleEntity.fullName.toString()");
            rule2 = new NotARule(string);
        }
        return rule2;
    }

    private static final Rule loadMpsRule(XdScript script) {
        Rule rule2;
        String string = script.getFullName().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"script.fullName.toString()");
        String fqName2 = string;
        try {
            Rule $receiver;
            Rule rule3;
            block7: {
                block6: {
                    String string2 = script.getScript();
                    if (string2 == null) {
                        throw (Throwable)new IllegalArgumentException("Script body is empty");
                    }
                    String scriptBody = string2;
                    $receiver = rule3 = RunInContextKt.loadMpsRule$default(scriptBody, fqName2, null, 4, null);
                    if (!BaseApplication.isInsideRequestProcessing()) break block6;
                    HttpServletRequest httpServletRequest = BaseApplication.getRequest();
                    Intrinsics.checkExpressionValueIsNotNull((Object)httpServletRequest, (String)"BaseApplication.getRequest()");
                    if (StringsKt.equals((String)httpServletRequest.getMethod(), (String)"GET", (boolean)true)) break block7;
                }
                script.setName($receiver.getName());
            }
            $receiver.setOwner(script);
            rule2 = rule3;
        }
        catch (Exception e) {
            LocalizationObject cause = new LocalizationObject("WorkflowRule.Error_while_loading_script_for_rule_{0}_{1}", new Object[]{fqName2, e.getMessage()});
            LoadedRulesLocal.Companion.getLogger().error(cause.getDefaultMessage(), (Throwable)e);
            throw (Throwable)new LocalizedLogicException((Localization)cause, e);
        }
        return rule2;
    }

    private static final Rule loadJsRule(XdScript script) {
        Rule rule2;
        block8: {
            block7: {
                Rule rule3;
                if (CollectionsKt.contains((Iterable)ignoredPackages, (Object)script.getWorkflow().getName())) {
                    return null;
                }
                CharSequence charSequence = script.getScript();
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    return null;
                }
                SimpleEvalStatus status = new SimpleEvalStatus();
                BeansKt.getWorkflowRuleRunner().run(script, (AbstractEvaluationParameters)new SimpleEvalParams(), (EvaluationStatus)status);
                Object object = status.getOutput("exportedRule");
                if (object == null) {
                    return null;
                }
                Object rule4 = object;
                Object object2 = rule4;
                if (!(object2 instanceof Rule)) {
                    object2 = null;
                }
                if ((rule2 = (Rule)object2) == null) break block7;
                Rule $receiver = rule3 = rule2;
                $receiver.setOwner(script);
                rule2 = rule3;
                if (rule2 != null) break block8;
            }
            throw (Throwable)new LocalizedLogicException((Localization)new LocalizationObject("LoadedRules.Script_{0}_exports_object_of_incorrect_type_under_name_rule", new Object[]{script.getFullName()}));
        }
        return rule2;
    }

    static {
        ThreadLocal threadLocal = ThreadLocal.withInitial(currentlyProcessedRules.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(threadLocal, (String)"ThreadLocal.withInitial \u2026leMapOf<String, Rule>()\n}");
        currentlyProcessedRules = threadLocal;
        ignoredPackages = SetsKt.setOf((Object[])new String[]{"@jetbrains/youtrack-scripting-api", "@jetbrains/youtrack-scripting-api-import", "@jetbrains/kotlin", "@jetbrains/kotlin-workflow-api", "jetbrains/youtrack/imports/jira"});
    }

    @NotNull
    public static final /* synthetic */ Rule access$loadRule(@NotNull XdScript script) {
        return LoadedRulesLocalKt.loadRule(script);
    }

    @NotNull
    public static final /* synthetic */ Rule access$popRuleFromTransaction(@NotNull XdScript script) {
        return LoadedRulesLocalKt.popRuleFromTransaction(script);
    }

    @Nullable
    public static final /* synthetic */ Rule access$loadJsRule(@NotNull XdScript script) {
        return LoadedRulesLocalKt.loadJsRule(script);
    }

    @Nullable
    public static final /* synthetic */ Rule access$loadMpsRule(@NotNull XdScript script) {
        return LoadedRulesLocalKt.loadMpsRule(script);
    }
}

