var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');
var days = require("./date-utils").days;

exports.rule = entities.Issue.onSchedule({
  title: workflow.i18n('Raise priority from "Major" to "Critical" if not resolved in 10 days'),
  search: '#Unresolved priority:Major',
  cron: '0 5 8 1/1 * ? *',
  guard: function(ctx) {
    return ctx.issue.created < Date.now() - days(10);
  },
  action: function(ctx) {
    ctx.issue.fields.Priority = ctx.Priority.Critical;
  },
  requirements: {
    Priority: {
      type: entities.EnumField.fieldType,
      Major: {},
      Critical: {}
    }
  }
});