var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Disable comments for verified issues'),
  guard: function(ctx) {
    var issue = ctx.issue;
    return issue.fields.State &&
      issue.fields.State.name === ctx.State.Verified.name &&
      !issue.fields.becomes(ctx.State, ctx.State.Verified);
  },
  action: function(ctx) {
    workflow.check(ctx.issue.comments.added.isEmpty(), workflow.i18n('Commenting for fixed and verified issues is disabled.'));
  },
  requirements: {
    State: {
      type: entities.State.fieldType,
      Verified: {}
    }
  }
});