var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Insert default description template for external users'),
  guard: function(ctx) {
    var issue = ctx.issue;
    return !issue.isReported && !issue.becomesReported && issue.description === null;
  },
  action: function(ctx) {
    ctx.issue.description = workflow.i18n('What steps will reproduce the problem?') +
      "\n1.\n2.\n3.\n\n" +
      workflow.i18n("What is the expected result?") +
      "\n\n" +
      workflow.i18n("What happens instead?") +
      "\n\n" +
      workflow.i18n("Please provide any additional information below.") +
      "\n" +
      workflow.i18n("Provide a screenshot if possible") +
      "\n";
  },
  requirements: {}
});