var workflow = require('@jetbrains/youtrack-scripting-api/workflow');
var entities = require('@jetbrains/youtrack-scripting-api/entities');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Raise priority when issue is duplicated by another issue'),
  guard: function (ctx) {
    return ctx.issue.links['is duplicated by'].added.isNotEmpty() && ctx.issue.fields.Priority;
  },
  action: function (ctx) {
    var issue = ctx.issue;
    var currentPriorityOrdinal = issue.fields.Priority.ordinal;
    issue.links['is duplicated by'].added.forEach(function (added) {
      if (added.project.key !== issue.project.key) {
        var anotherProjectField = added.project.findFieldByName(ctx.Priority.name);
        var bundlesAreEqual = function() {
          var set1 = anotherProjectField.values.entries();
          var set2 = ctx.Priority.values.entries();
          for (var next1 = set1.next(), next2 = set2.next(); ; next1 = set1.next(), next2 = set2.next()) {
            if (next1.done !== next2.done || (next1.value || {}).name !== (next2.value || {}).name) {
              return false;
            }
            if (next1.done || next2.done) {
              return true;
            }
          }
        };
        if (!anotherProjectField || !bundlesAreEqual()) {
          console.trace('Can not copy priority of a duplicate as there\'s no respective state in project ' + added.project.key + ' or value sets are not identical');
          return;
        }
      }
      if (added.fields.Priority && added.fields.Priority.ordinal < currentPriorityOrdinal) {
        issue.fields.Priority = added.fields.Priority.name; // need to use .name here as issues can belong to different projects
        currentPriorityOrdinal = issue.fields.Priority.ordinal;
      }
    });
  },
  requirements: {
    Priority: {
      type: entities.EnumField.fieldType
    },
    Duplicate: {
      type: entities.IssueLinkPrototype,
      outward: 'is duplicated by',
      inward: 'duplicates'
    }
  }
});