var workflow = require('@jetbrains/youtrack-scripting-api/workflow');
var entities = require('@jetbrains/youtrack-scripting-api/entities');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Set state to "Duplicate" when duplicates link is added to issue'),
  guard: function(ctx) {
    return ctx.issue.links.duplicates.added.isNotEmpty() &&
      ctx.issue.fields.State && ctx.issue.fields.State.name !== ctx.State.Duplicate.name;
  },
  action: function(ctx) {
    if (ctx.issue.canBeWrittenBy(ctx.State.name, ctx.currentUser)) {
      ctx.issue.fields.State = ctx.State.Duplicate;
    }
  },
  requirements: {
    State: {
      type: entities.State.fieldType,
      Duplicate: {}
    },
    Duplicate: {
      type: entities.IssueLinkPrototype,
      outward: 'is duplicated by',
      inward: 'duplicates'
    }
  }
});