var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Notify reporter to approve fix'),
  guard: function(ctx) {
    return ctx.issue.fields.becomes(ctx.State, ctx.State.Pending);
  },
  action: function(ctx) {
    var issue = ctx.issue;
    issue.fields.Assignee = issue.reporter;
    issue.reporter.notify(workflow.i18n('Please approve fix for the issue {0}', issue.id),
      workflow.i18n('You have reported issue {0}. Please verify the applied fix for the issue and set the appropriate state.', issue.id), true);
  },
  requirements: {
    State: {
      type: entities.EnumField.fieldType,
      Pending: {
        name: 'Pending verification'
      }
    },
    Assignee: {
      type: entities.User.fieldType
    }
  }
});