var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.stateMachine({
  title: workflow.i18n('Define transitions for "State" field for fixes that are approved by reporters'),
  fieldName: 'State',
  states: {
    Submitted: {
      initial: true,
      transitions: {
        open: {
          targetState: 'Open'
        }
      }
    },
    Open: {
      transitions: {
        fix: {
          targetState: 'Fixed'
        }
      }
    },
    Fixed: {
      onEnter: function(ctx) {
        ctx.issue.fields.required(ctx.FixedInBuild, workflow.i18n('Please set \'Fixed in build\' value.'));
      },
      transitions: {
        'Send for verification': {
          targetState: 'Pending verification'
        }
      }
    },
    'Pending verification': {
      onEnter: function(ctx) {
        var issue = ctx.issue;
        issue.fields.Assignee = issue.reporter;
        issue.reporter.notify(workflow.i18n('Please approve fix for the issue {0}', issue.id),
          workflow.i18n('You have reported issue {0}. Please verify the applied fix for the issue and set the appropriate state.', issue.id), true);
      },
      transitions: {
        Approve: {
          targetState: 'Verified'

        },
        Reopen: {
          targetState: 'Open'
        }
      }
    },
    Verified: {
      transitions: {
        Reopen: {
          targetState: 'Open'
        }
      }
    }
  },
  requirements: {
    FixedInBuild: {
      type: entities.Build.fieldType,
      name: 'Fixed in build'
    },
    Assignee: {
      type: entities.User.fieldType
    }
  }
});