var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Collect related emails on issue creation'),
  guard: function(ctx) {
    return ctx.issue.becomesReported;
  },
  action: function(ctx) {
    var issue = ctx.issue;
    var lastMessageRelatedEmailsStr = issue.fields.lastEmails;
    var isBlank = function(str) {
      return !str || str.trim().length === 0;
    };
    var lastMessageRelatedEmails = isBlank(lastMessageRelatedEmailsStr) ? [] : lastMessageRelatedEmailsStr.split(' ');

    if (lastMessageRelatedEmails.length) {
      var fromServiceEmail = issue.project.notificationEmail;
      var isEmailAllowed = function(email) {
        return email && email.length && email.toUpperCase() !== fromServiceEmail.toUpperCase();
      };
      var allRelatedEmailsStr = issue.fields.allEmails;
      var allRelatedEmails = isBlank(allRelatedEmailsStr) ? [] : allRelatedEmailsStr.split(' ');

      var newUsersEmails = lastMessageRelatedEmails.filter(function(email) {
        return isEmailAllowed(email) && allRelatedEmails.indexOf(email) === -1;
      });
      if (newUsersEmails.length) {
        issue.fields.allEmails = allRelatedEmails.concat(newUsersEmails).join(' ');
      }
      issue.fields.lastEmails = null;
    }
  },
  requirements: {
    lastEmails: {
      name: 'Last message related emails',
      type: entities.Field.stringType
    },
    allEmails: {
      name: 'All related emails',
      type: entities.Field.stringType
    }
  }
});