var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Notify assignee when an issue linked as "required for" is resolved'),
  guard: function(ctx) {
    var issue = ctx.issue;
    return issue.fields.isChanged(ctx.State) && issue.fields.State && issue.fields.State.isResolved &&
      (!issue.fields.oldValue(ctx.State) || !issue.fields.oldValue(ctx.State).isResolved);
  },
  action: function(ctx) {
    if (ctx.issue.links['is required for'].isNotEmpty()) {
      var getLinkToIssue = function(i) {
        return '<a href="' + i.url + '">' + i.id + '</a> ' +
          '<a href="' + i.url + '">' + i.summary + '</a>';
      };

      ctx.issue.links['is required for'].forEach(function(dependent) {
        var assignee = dependent.fields.Assignee;
        var state = dependent.fields.State;

        if (assignee && assignee.login !== ctx.currentUser.login && (!state || !state.isResolved)) {

          var subject = workflow.i18n('[Youtrack, Required issue is resolved]');
          var body = [
            workflow.i18n('Dear assignee of {0}.', getLinkToIssue(ctx.issue)),
            '<br>',
            workflow.i18n('I\'m pleased to inform you that the issue required for your work - ' +
              '{0} - just has been resolved.', getLinkToIssue(dependent)),
            '<p style="color: gray; font-size: 12px; margin-top: 1em; border-top: 1px solid #D4D5D6">',
            workflow.i18n('Sincerely yours, YouTrack'),
            '</p>'
          ].join('\n');

          assignee.notify(subject, body, true);
        }
      });
    }
  },
  requirements: {
    State: {
      type: entities.State.fieldType
    },
    Assignee: {
      type: entities.User.fieldType
    },
    Depend: {
      type: entities.IssueLinkPrototype,
      name: 'Depend',
      outward: 'is required for',
      inward: 'depends on'
    }
  }
});