var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');
var regex = /\s|,|;|\.|\?|!/;

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Add vote to issue when comment contains "+1"'),
  guard: function(ctx) {
    return ctx.issue.comments.added.isNotEmpty();
  },
  action: function(ctx) {
    var issue = ctx.issue;

    var index = -1;
    issue.comments.added.forEach(function(comment) {
      if (index < 0 && comment.text) {
        index = comment.text.split(regex).indexOf('+1');
      }
    });
    if (index >= 0) {
      ctx.currentUser.voteIssue(issue);
      if (issue.isChanged('votes')) {
        workflow.message(workflow.i18n('The single vote is added.'));
      }
    }
  },
  requirements: {}
});