var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Set subsystem owner as assignee for unassigned issues'),
  guard: function(ctx) {
    return !ctx.issue.fields.Assignee && ctx.issue.fields.Subsystem;
  },
  action: function(ctx) {
    var issue = ctx.issue;
    if ((issue.isReported && (issue.fields.isChanged(ctx.Subsystem) || issue.isChanged('project'))) || issue.becomesReported) {
      issue.fields.Assignee = issue.fields.Subsystem.owner;
    }
  },
  requirements: {
    Assignee: {
      type: entities.User.fieldType
    },
    Subsystem: {
      type: entities.OwnedField.fieldType
    }
  }
});