var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Update assignee for subtask when parent issue is reassigned'),
  guard: function(ctx) {
    return ctx.issue.fields.isChanged(ctx.Assignee);
  },
  action: function(ctx) {
    var issue = ctx.issue;

    var safeSetAssignee = function(subtask) {
      if (subtask.project && subtask.isReported && !subtask.project.isArchived) {
        if (subtask.project.key === issue.project.key || subtask.project.findFieldByName(ctx.Assignee.name)) {
          if ((issue.fields.oldValue(ctx.Assignee) || {}).login === (subtask.fields.Assignee || {}).login) {
            if (!issue.fields.Assignee ||
              subtask.project.findFieldByName(ctx.Assignee.name).findValueByLogin(issue.fields.Assignee.login)) {
              subtask.fields.Assignee = issue.fields.Assignee;
            }
          }
        }
      }
    };

    issue.links['parent for'].forEach(safeSetAssignee);
  },
  requirements: {
    Assignee: {
      type: entities.User.fieldType
    },
    Subtask: {
      type: entities.IssueLinkPrototype,
      name: 'Subtask',
      outward: 'parent for',
      inward: 'subtask of'
    }
  }
});