var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');
var copy = require('./copy-values');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Set fix versions for subtasks when fix versions are added to parent task'),
  guard: function(ctx) {
    return ctx.issue.fields.FixVersions.added.isNotEmpty();
  },
  action: function(ctx) {
    var issue = ctx.issue;

    var safeSetFixVersions = function(subtask) {
      if (subtask.project && subtask.isReported && !subtask.project.isArchived) {
        if (subtask.project.key === issue.project.key || subtask.project.findFieldByName(ctx.FixVersions.name)) {
          if (!subtask.isResolved) {
            copy.copyValues(issue.fields.FixVersions.added, subtask, ctx.FixVersions);
          }
        }
      }
    };

    issue.links['parent for'].forEach(safeSetFixVersions);
  },
  requirements: {
    FixVersions: {
      type: entities.ProjectVersion.fieldType,
      name: 'Fix versions',
      multi: true
    }
  }
});