var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Copy subsystem from parent task when issue is linked as a subtask'),
  guard: function(ctx) {
    return ctx.issue.links['parent for'].added.isNotEmpty() && ctx.issue.fields.Subsystem;
  },
  action: function(ctx) {
    var issue = ctx.issue;

    var safeSetSubsystem = function(subtask) {
      if (subtask.project && !subtask.project.isArchived) {
        if (subtask.project.key === issue.project.key || subtask.project.findFieldByName(ctx.Subsystem.name)) {
          if (!subtask.fields.Subsystem) {
            var value = subtask.project.findFieldByName(ctx.Subsystem.name).findValueByName(issue.fields.Subsystem.name);
            if (value) {
              subtask.fields.Subsystem = value;
            }
          }
        }
      }
    };

    issue.links['parent for'].added.forEach(safeSetSubsystem);
  },
  requirements: {
    Subsystem: {
      type: entities.EnumField.fieldType
    },
    SubtaskOf: {
      type: entities.IssueLinkPrototype,
      name: 'Subtask',
      outward: 'parent for',
      inward: 'subtask of'
    }
  }
});